/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.oboracle;

import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.oboracle.AbstractObOracleConstraint;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleSchema;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.List;

public class ObOracleForeignKey
extends AbstractObOracleConstraint {
    private static final List<String> SUPPORTED_DELETE_RULES = Lists.newArrayList((Object[])new String[]{"C", "CASCADE", "N", "SET NULL"});

    public ObOracleForeignKey(ObOracleSchema schema) {
        super(schema);
    }

    @Override
    public ObOracleSchema getSchema() {
        return (ObOracleSchema)super.getSchema();
    }

    public void setSchema(ObOracleSchema schema) {
        super.setSchema(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank(this.getConstraintName())) {
            sb.append("CONSTRAINT ").append(this.wrap(this.getConstraintName())).append(" ");
        }
        sb.append("FOREIGN KEY").append((CharSequence)this.joinForeignConstraintColumns());
        sb.append(" REFERENCES ").append(this.getRefOwnerTableName());
        sb.append((CharSequence)this.joinRefConstraintColumns());
        if (SUPPORTED_DELETE_RULES.contains(this.getDeleteRule())) {
            sb.append(this.safetyMapping(DELETE_RULE_MAPPING, this.getDeleteRule()));
        }
        return sb;
    }

    @Override
    public String toString() {
        return "ObOracleForeignKey()";
    }

    public ObOracleForeignKey() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObOracleForeignKey)) {
            return false;
        }
        ObOracleForeignKey other = (ObOracleForeignKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObOracleForeignKey;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

