/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.oboracle;

import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractView;
import com.oceanbase.tools.loaddump.schema.model.CreateObjectDefine;
import com.oceanbase.tools.loaddump.schema.model.ObjectDefine;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleColumn;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOraclePrimaryKey;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleSchema;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleUniqueKey;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ObOracleView
extends AbstractView {
    private final Map<String, ObOracleColumn> columnMapping = new LinkedHashMap<String, ObOracleColumn>();
    private final Map<String, ObOracleUniqueKey> uniqueMapping = new LinkedHashMap<String, ObOracleUniqueKey>();
    private Integer textLength;
    private Integer oidTextLength;
    private String oidText;
    private String viewType;
    private String superViewName;
    private String editioningView;
    private ObOraclePrimaryKey primaryKey;

    public ObOracleView(ObOracleSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        String text = this.getText();
        if (this.isFullText()) {
            return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.VIEW, this.getSimpleObjectName(), this.terminate(text))});
        }
        StringBuilder sb = new StringBuilder();
        String objectName = this.getSchemaObjectName();
        sb.append("CREATE OR REPLACE VIEW ").append(objectName);
        Collection<ObOracleColumn> columns = this.getColumnMapping().values();
        if (CollectionUtils.isNotEmpty(columns)) {
            sb.append(" (");
            Iterator<ObOracleColumn> iter1 = this.getColumnMapping().values().iterator();
            while (iter1.hasNext()) {
                sb.append("\n\t").append(this.wrap(iter1.next().getColumnName()));
                if (!iter1.hasNext()) continue;
                sb.append(",");
            }
            ObOraclePrimaryKey primaryKey = this.getPrimaryKey();
            if (primaryKey != null) {
                sb.append(",").append("\n\t").append((CharSequence)primaryKey.buildGrammar());
            }
            Iterator<ObOracleUniqueKey> iter2 = this.getUniqueMapping().values().iterator();
            while (iter2.hasNext()) {
                sb.append(",").append("\n\t").append((CharSequence)iter2.next().buildGrammar());
            }
            sb.append(")");
        }
        sb.append(" AS ").append("\n").append(text);
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.VIEW, this.getSimpleObjectName(), this.terminate(sb))});
    }

    public ObOracleView() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObOracleView)) {
            return false;
        }
        ObOracleView other = (ObOracleView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$textLength = this.getTextLength();
        Integer other$textLength = other.getTextLength();
        if (this$textLength == null ? other$textLength != null : !((Object)this$textLength).equals(other$textLength)) {
            return false;
        }
        Integer this$oidTextLength = this.getOidTextLength();
        Integer other$oidTextLength = other.getOidTextLength();
        if (this$oidTextLength == null ? other$oidTextLength != null : !((Object)this$oidTextLength).equals(other$oidTextLength)) {
            return false;
        }
        Map<String, ObOracleColumn> this$columnMapping = this.getColumnMapping();
        Map<String, ObOracleColumn> other$columnMapping = other.getColumnMapping();
        if (this$columnMapping == null ? other$columnMapping != null : !((Object)this$columnMapping).equals(other$columnMapping)) {
            return false;
        }
        Map<String, ObOracleUniqueKey> this$uniqueMapping = this.getUniqueMapping();
        Map<String, ObOracleUniqueKey> other$uniqueMapping = other.getUniqueMapping();
        if (this$uniqueMapping == null ? other$uniqueMapping != null : !((Object)this$uniqueMapping).equals(other$uniqueMapping)) {
            return false;
        }
        String this$oidText = this.getOidText();
        String other$oidText = other.getOidText();
        if (this$oidText == null ? other$oidText != null : !this$oidText.equals(other$oidText)) {
            return false;
        }
        String this$viewType = this.getViewType();
        String other$viewType = other.getViewType();
        if (this$viewType == null ? other$viewType != null : !this$viewType.equals(other$viewType)) {
            return false;
        }
        String this$superViewName = this.getSuperViewName();
        String other$superViewName = other.getSuperViewName();
        if (this$superViewName == null ? other$superViewName != null : !this$superViewName.equals(other$superViewName)) {
            return false;
        }
        String this$editioningView = this.getEditioningView();
        String other$editioningView = other.getEditioningView();
        if (this$editioningView == null ? other$editioningView != null : !this$editioningView.equals(other$editioningView)) {
            return false;
        }
        ObOraclePrimaryKey this$primaryKey = this.getPrimaryKey();
        ObOraclePrimaryKey other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !((Object)this$primaryKey).equals(other$primaryKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObOracleView;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $textLength = this.getTextLength();
        result = result * 59 + ($textLength == null ? 43 : ((Object)$textLength).hashCode());
        Integer $oidTextLength = this.getOidTextLength();
        result = result * 59 + ($oidTextLength == null ? 43 : ((Object)$oidTextLength).hashCode());
        Map<String, ObOracleColumn> $columnMapping = this.getColumnMapping();
        result = result * 59 + ($columnMapping == null ? 43 : ((Object)$columnMapping).hashCode());
        Map<String, ObOracleUniqueKey> $uniqueMapping = this.getUniqueMapping();
        result = result * 59 + ($uniqueMapping == null ? 43 : ((Object)$uniqueMapping).hashCode());
        String $oidText = this.getOidText();
        result = result * 59 + ($oidText == null ? 43 : $oidText.hashCode());
        String $viewType = this.getViewType();
        result = result * 59 + ($viewType == null ? 43 : $viewType.hashCode());
        String $superViewName = this.getSuperViewName();
        result = result * 59 + ($superViewName == null ? 43 : $superViewName.hashCode());
        String $editioningView = this.getEditioningView();
        result = result * 59 + ($editioningView == null ? 43 : $editioningView.hashCode());
        ObOraclePrimaryKey $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : ((Object)$primaryKey).hashCode());
        return result;
    }

    public Map<String, ObOracleColumn> getColumnMapping() {
        return this.columnMapping;
    }

    public Map<String, ObOracleUniqueKey> getUniqueMapping() {
        return this.uniqueMapping;
    }

    public Integer getTextLength() {
        return this.textLength;
    }

    public void setTextLength(Integer textLength) {
        this.textLength = textLength;
    }

    public Integer getOidTextLength() {
        return this.oidTextLength;
    }

    public void setOidTextLength(Integer oidTextLength) {
        this.oidTextLength = oidTextLength;
    }

    public String getOidText() {
        return this.oidText;
    }

    public void setOidText(String oidText) {
        this.oidText = oidText;
    }

    public String getViewType() {
        return this.viewType;
    }

    public void setViewType(String viewType) {
        this.viewType = viewType;
    }

    public String getSuperViewName() {
        return this.superViewName;
    }

    public void setSuperViewName(String superViewName) {
        this.superViewName = superViewName;
    }

    public String getEditioningView() {
        return this.editioningView;
    }

    public void setEditioningView(String editioningView) {
        this.editioningView = editioningView;
    }

    public ObOraclePrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(ObOraclePrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }
}

