/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.strategy;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.oceanbase.tools.loaddump.common.model.Pair;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class AdaptiveBatchStrategy {
    private static final long MAX_BATCH_BYTE_SIZE = 0x100000L;
    static final TreeMap<Integer, Integer> ADAPTIVE_TREE_MAP = new TreeMap<Integer, Integer>(){
        {
            int i;
            this.put(0, 1);
            for (i = 1; i < 10; ++i) {
                this.put(i, i);
            }
            i = 100;
            int j = 1;
            while (i <= 800) {
                this.put(i, i);
                i = j * 100;
                ++j;
            }
        }
    };
    private final long maxBatchByteSize;
    private final LoadingCache<Pair<String, Long>, Integer> consistencyCache;

    public AdaptiveBatchStrategy() {
        this(0x100000L);
    }

    public AdaptiveBatchStrategy(long maxBatchByteSize) {
        this.maxBatchByteSize = maxBatchByteSize;
        this.consistencyCache = this.createConsistencyCache();
    }

    private LoadingCache<Pair<String, Long>, Integer> createConsistencyCache() {
        return CacheBuilder.newBuilder().concurrencyLevel(1).recordStats().build((CacheLoader)new CacheLoader<Pair<String, Long>, Integer>(){

            public synchronized Integer load(@NotNull Pair<String, Long> key) {
                long firstRowSize = key.getRight();
                int realBatchSize = (int)(AdaptiveBatchStrategy.this.maxBatchByteSize / firstRowSize);
                Map.Entry<Integer, Integer> entry = ADAPTIVE_TREE_MAP.floorEntry(realBatchSize);
                return entry == null ? null : entry.getValue();
            }
        });
    }

    public int getBatchSize(String tableName, long firstRowSize, int colNum, int defaultBatch) {
        if (defaultBatch > 0) {
            return defaultBatch;
        }
        int maxBatch = 65535 / colNum;
        try {
            Integer batchSize = (Integer)this.consistencyCache.get(new Pair<String, Long>(tableName, firstRowSize));
            return batchSize == null ? defaultBatch : Math.min(batchSize, maxBatch);
        }
        catch (Exception e) {
            return defaultBatch;
        }
    }
}

