/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.tablefmt;

import com.oceanbase.tools.loaddump.tablefmt.Cell;
import java.util.ArrayList;
import java.util.List;

public class Column {
    private int colIndex;
    private List<Cell> cells;
    private int minWidth;
    private int maxWidth;
    private int width;

    public Column(int colIndex, int minWidth, int maxWidth) {
        this.colIndex = colIndex;
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.cells = new ArrayList<Cell>();
        this.width = 0;
    }

    public Column(int colIndex, int width) {
        this.colIndex = colIndex;
        this.minWidth = width;
        this.maxWidth = width;
        this.cells = new ArrayList<Cell>();
        this.width = width;
    }

    public void calculateWidth(List<Column> columns, int separatorWidth) {
        this.width = this.minWidth;
        for (Cell cell : this.cells) {
            int cellTightWidth;
            int tw;
            int previousWidth = 0;
            if (cell.getColSpan() > 1) {
                for (int pos = this.colIndex - cell.getColSpan() + 1; pos < this.colIndex; ++pos) {
                    previousWidth = previousWidth + columns.get(pos).getColumnWidth() + separatorWidth;
                }
            }
            if ((tw = (cellTightWidth = cell != null ? cell.getTightWidth(this.maxWidth) : 0) - previousWidth) <= this.width) continue;
            this.width = tw;
        }
    }

    public int getColumnWidth() {
        return this.width;
    }

    public void add(Cell cell) {
        this.cells.add(cell);
    }

    public int getSize() {
        return this.cells.size();
    }

    public Cell get(int index) {
        return this.cells.get(index);
    }

    public List<Cell> getCells() {
        return this.cells;
    }

    public void setWidthRange(int minWidth, int maxWidth) {
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
    }
}

