/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.tablefmt;

import com.oceanbase.tools.loaddump.tablefmt.BorderStyle;
import com.oceanbase.tools.loaddump.tablefmt.Cell;
import com.oceanbase.tools.loaddump.tablefmt.CellStyle;
import com.oceanbase.tools.loaddump.tablefmt.Column;
import com.oceanbase.tools.loaddump.tablefmt.Filler;
import com.oceanbase.tools.loaddump.tablefmt.Row;
import com.oceanbase.tools.loaddump.tablefmt.ShownBorders;
import com.oceanbase.tools.loaddump.tablefmt.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TableStyle {
    public BorderStyle borderStyle;
    private String prompt;
    private ShownBorders shownBorders;

    public TableStyle(BorderStyle borderStyle, ShownBorders shownBorders, int leftMargin, String prompt) {
        this.borderStyle = borderStyle;
        this.shownBorders = shownBorders;
        this.prompt = prompt;
        if (this.prompt == null) {
            this.prompt = leftMargin > 0 ? Filler.getFiller(leftMargin) : "";
        }
    }

    private String escapeXmlIfRequired(String txt1, String txt2) {
        return txt1 + txt2;
    }

    public StringBuilder renderTable(Table table) {
        StringBuilder sb = new StringBuilder(4096);
        int totalRows = table.getRows().size();
        Row previousRow = null;
        boolean firstRenderedRow = true;
        for (int i = 0; i < totalRows; ++i) {
            Row r = table.getRows().get(i);
            boolean isFirst = i == 0;
            boolean isSecond = i == 1;
            boolean isIntermediate = i > 1 && i < totalRows - 1;
            boolean isLast = i == totalRows - 1;
            List<String> rr = this.renderRow(r, previousRow, table.getColumns(), isFirst, isSecond, isIntermediate, isLast);
            for (String line : rr) {
                if (firstRenderedRow) {
                    firstRenderedRow = false;
                } else {
                    sb.append("\n");
                }
                sb.append(line);
            }
            previousRow = r;
        }
        return sb;
    }

    String[] renderAsStringArray(Table table) {
        int totalRows = table.getRows().size();
        Row previousRow = null;
        ArrayList<String> allLines = new ArrayList<String>();
        for (int i = 0; i < totalRows; ++i) {
            Row r = table.getRows().get(i);
            boolean isFirst = i == 0;
            boolean isSecond = i == 1;
            boolean isIntermediate = i > 1 && i < totalRows - 1;
            boolean isLast = i == totalRows - 1;
            List<String> rr = this.renderRow(r, previousRow, table.getColumns(), isFirst, isSecond, isIntermediate, isLast);
            for (String line : rr) {
                allLines.add(line);
            }
            previousRow = r;
        }
        String[] result = new String[allLines.size()];
        int i = 0;
        Iterator iterator = allLines.iterator();
        while (iterator.hasNext()) {
            String line;
            result[i] = line = (String)iterator.next();
            ++i;
        }
        return result;
    }

    void renderRow(Appendable ap, Row r, Row previousRow, List<Column> columns, boolean isFirst, boolean isSecond, boolean isIntermediate, boolean isLast) throws IOException {
        List<String> rr = this.renderRow(r, previousRow, columns, isFirst, isSecond, isIntermediate, isLast);
        boolean firstRenderedRow = isFirst;
        for (String line : rr) {
            if (firstRenderedRow) {
                firstRenderedRow = false;
            } else {
                ap.append("\n");
            }
            ap.append(line);
        }
    }

    private List<String> renderRow(Row r, Row previousRow, List<Column> columns, boolean isFirst, boolean isSecond, boolean isIntermediate, boolean isLast) {
        ArrayList<String> list = new ArrayList<String>();
        if (isFirst) {
            if (this.shownBorders.showTopBorder()) {
                list.add(this.escapeXmlIfRequired(this.prompt, this.shownBorders.renderTopBorder(columns, this.borderStyle, r)));
            }
        } else if (isIntermediate && this.shownBorders.showMiddleSeparator() || isSecond && this.shownBorders.showHeaderSeparator() || isLast && this.shownBorders.showFooterSeparator()) {
            list.add(this.escapeXmlIfRequired(this.prompt, this.shownBorders.renderMiddleSeparator(columns, this.borderStyle, previousRow, r)));
        }
        list.add(this.escapeXmlIfRequired(this.prompt, this.renderContentRow(r, columns)));
        if (isLast && this.shownBorders.showBottomBorder()) {
            list.add(this.escapeXmlIfRequired(this.prompt, this.shownBorders.renderBottomBorder(columns, this.borderStyle, r)));
        }
        return list;
    }

    private String renderContentRow(Row r, List<Column> columns) {
        StringBuilder sb = new StringBuilder(2048);
        if (this.shownBorders.showLeftBorder()) {
            sb.append(this.borderStyle.getLeft());
        }
        int totalColumns = columns.size();
        int j = 0;
        for (Cell cell : r.getCells()) {
            if (j != 0 && (j > 1 && j < totalColumns - 1 && this.shownBorders.showCenterSeparator() || j == 1 && this.shownBorders.showLeftSeparator() || j == totalColumns - 1 && this.shownBorders.showRightSeparator())) {
                sb.append(this.borderStyle.getCenter());
            }
            int sepWidth = this.borderStyle.getCenter().length();
            int width = -sepWidth;
            for (int pos = j; pos < j + cell.getColSpan(); ++pos) {
                width = width + sepWidth + columns.get(pos).getColumnWidth();
            }
            String renderedCell = cell.render(width);
            sb.append(renderedCell);
            j += cell.getColSpan();
        }
        while (j < totalColumns) {
            if (j != 0 && (j > 1 && j < totalColumns - 1 && this.shownBorders.showCenterSeparator() || j == 1 && this.shownBorders.showLeftSeparator() || j == totalColumns - 1 && this.shownBorders.showRightSeparator())) {
                sb.append(this.borderStyle.getCenter());
            }
            Column col = columns.get(j);
            String renderedCell = CellStyle.renderNullCell(col.getColumnWidth());
            sb.append(renderedCell);
            ++j;
        }
        if (this.shownBorders.showRightBorder()) {
            sb.append(this.borderStyle.getRight());
        }
        return sb.toString();
    }
}

