/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.utils;

import com.oceanbase.tools.loaddump.utils.ArrayUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import lombok.NonNull;

public class ExceptionUtils
extends org.apache.commons.lang3.exception.ExceptionUtils {
    public static String getMessage(Throwable th) {
        if (th == null) {
            return "No available error messages!";
        }
        String message = th.getMessage();
        if (StringUtils.isEmpty(message)) {
            StringBuilder sb = new StringBuilder();
            sb.append(th.getClass().getName()).append(": ");
            StackTraceElement[] elements = th.getStackTrace();
            if (ArrayUtils.isNotEmpty(elements)) {
                ArrayList<String> traces = new ArrayList<String>();
                for (int i = 0; i < elements.length; ++i) {
                    StackTraceElement ele = elements[i];
                    String fileName = ele.getFileName();
                    fileName = fileName.substring(0, fileName.length() - 5);
                    traces.add(fileName + "." + ele.getMethodName() + "(Line:" + ele.getLineNumber() + ")");
                    if (i > 0) break;
                }
                Collections.reverse(traces);
                sb.append(String.join((CharSequence)" => ", traces));
                message = sb.toString();
            }
        }
        return message;
    }

    public static String getRootCauseMessage(Throwable th) {
        Throwable root = ExceptionUtils.getRootCause((Throwable)th);
        String msg = ExceptionUtils.getMessage(root == null ? th : root);
        if (msg != null) {
            int index = msg.indexOf("SQL statement");
            if (index > -1) {
                msg = msg.substring(0, index);
            }
        } else {
            msg = th.getClass().getName() + ". No more errors, you can use -Ddebug to see the stacktrace.";
        }
        return msg;
    }

    public static boolean isDuplicateRecord(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return message.contains("Duplicate entry") || message.contains("unique constraint");
    }

    public static boolean isDiscardRecord(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return ExceptionUtils.isDuplicateRecord(message) || ExceptionUtils.isInvalidPartRecord(message);
    }

    public static boolean isInvalidPartRecord(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return message.contains("Table has no partition for value") || message.contains("inserted partition key does not map to any partition");
    }

    public static boolean isNetworkError(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return message.contains("RPC send error") || message.contains("Operation timed out") || message.contains("Connection reset") || message.contains("Connection refused") || message.contains("Can not read response from server") || message.contains("Network is unreachable") || message.contains("Read timed out") || message.contains("Connect timed out") || message.contains("unexpected end of stream");
    }

    public static boolean isObserverError(String message) {
        return message.contains("Transaction exiting") || message.contains("Transaction is killed") || message.contains("Transaction rollbacked") || message.contains("transaction need rollback") || message.contains("Transaction context does not exist") || message.contains("transaction needs rollback") || message.contains("-4012, Timeout") || message.contains("No memory or reach tenant memory limit");
    }

    public static boolean isBadRecord(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return message.contains("Can not read response from server") || message.contains("invalid number") || message.contains("value too large for column") || message.contains("Out of range value for column") || message.contains("RPC send error") || message.contains("Data too long for column") || message.contains("value larger than specified precision allowed for this column") || message.contains("date format picture ends before converting entire input string") || message.contains("Incorrect value") || message.contains("Column count doesn't match value count") || message.contains("a non-numeric character was found where a numeric was expected") || message.contains("inconsistent datatypes") || message.contains("Incorrect integer value") || message.contains("Incorrect string value") || message.contains("cannot be null") || message.contains("cannot insert NULL into") || message.contains("invalid hex number") || message.contains("not a valid month") || message.contains("Data truncated for argument");
    }

    public static String parseDuplicatedKey(@NonNull String message) {
        String keyWithQuotation;
        String[] arr;
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (message.contains("unique constraint")) {
            String keyWithQuotation2;
            String[] arr2 = message.split(" ");
            if (arr2.length > 1 && (keyWithQuotation2 = arr2[arr2.length - 2]).startsWith("'") && keyWithQuotation2.endsWith("'")) {
                return keyWithQuotation2.substring(1, keyWithQuotation2.length() - 1);
            }
        } else if (message.contains("Duplicate entry") && (arr = message.split(" ")).length > 0 && (keyWithQuotation = arr[arr.length - 1]).startsWith("'") && keyWithQuotation.endsWith("'")) {
            return keyWithQuotation.substring(1, keyWithQuotation.length() - 1);
        }
        return "";
    }
}

