/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import com.oceanbase.tools.loaddump.vmoption.JvmArgs;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JdbcUtils {
    private static final Logger log = LoggerFactory.getLogger(JdbcUtils.class);
    private static final String SET_ENCODING = "set names ";
    private static final String OPEN_AUTOCOMMIT = "set autocommit=1";
    private static final String CLOSE_AUTOCOMMIT = "set autocommit=0";
    private static final String SET_ALLOWED_PACKET = "set global max_allowed_packet=";
    private static final String SET_SECURE_FILE_PRIV = "set global secure_file_priv=";
    private static final String OPEN_FOREIGN_CHECKS = "SET FOREIGN_KEY_CHECKS=1";
    private static final String CLOSE_FOREIGN_CHECKS = "SET FOREIGN_KEY_CHECKS=0";
    private static final String TRX_TIMEOUT = "set @@session.ob_trx_timeout=";
    private static final String QUERY_TIMEOUT = "set @@session.ob_query_timeout=";
    private static final String NET_READ_TIMEOUT = "set session net_read_timeout=";
    private static final String NET_WRITE_TIMEOUT = "set session net_write_timeout=";
    private static final String PROXY_ROUTE_POLICY = "set @proxy_route_policy= ";
    private static final String SET_OPEN_CURSORS = "alter system set open_cursors=";

    private JdbcUtils() {
    }

    public static void close(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                log.warn("Close {} failed", (Object)closeable.getClass().getName());
            }
        }
    }

    public static void setTrxTimeout(Connection conn, long timeout) {
        JdbcUtils.execute(conn, TRX_TIMEOUT + timeout);
    }

    public static void setQryTimeout(Connection conn, long timeout) {
        JdbcUtils.execute(conn, QUERY_TIMEOUT + timeout);
    }

    public static void setNetReadTimeout(Connection conn, long timeout) {
        JdbcUtils.execute(conn, NET_READ_TIMEOUT + timeout);
    }

    public static void setNetWriteTimeout(Connection conn, long timeout) {
        JdbcUtils.execute(conn, NET_WRITE_TIMEOUT + timeout);
    }

    public static void setProxyRoutePolicy(Connection conn, String policy) {
        JdbcUtils.execute(conn, "set @proxy_route_policy= '" + policy + "'");
    }

    public static void setEncoding(Connection conn, String encoding) {
        JdbcUtils.execute(conn, SET_ENCODING + encoding);
    }

    public static void setSystemOpenCursors(Connection conn, int maxOpenCursors) {
        JdbcUtils.execute(conn, SET_OPEN_CURSORS + maxOpenCursors);
    }

    public static void setMaxAllowedPacket(Connection conn, long maxAllowedPacket) {
        JdbcUtils.execute(conn, SET_ALLOWED_PACKET + maxAllowedPacket);
    }

    public static void setSecureFilePriv(Connection conn, String path) {
        JdbcUtils.execute(conn, SET_SECURE_FILE_PRIV + path);
    }

    public static void setNlsDateFormat(Connection conn, String nlsDateFormat) {
        if (StringUtils.isNotBlank(nlsDateFormat)) {
            JdbcUtils.execute(conn, "alter session set nls_date_format='" + nlsDateFormat + "'");
        }
    }

    public static void setNlsTimestampFormat(Connection conn, String nlsTimestampFormat) {
        if (StringUtils.isNotBlank(nlsTimestampFormat)) {
            JdbcUtils.execute(conn, "alter session set nls_timestamp_format='" + nlsTimestampFormat + "'");
        }
    }

    public static void setNlsTimestampTzFormat(Connection conn, String nlsTimestampTzFormat) {
        if (StringUtils.isNotBlank(nlsTimestampTzFormat)) {
            JdbcUtils.execute(conn, "alter session set nls_timestamp_tz_format='" + nlsTimestampTzFormat + "'");
        }
    }

    @Deprecated
    public static void setForeignKeyChecks(Connection conn, boolean open) {
        JdbcUtils.execute(conn, open ? OPEN_FOREIGN_CHECKS : CLOSE_FOREIGN_CHECKS);
    }

    public static void setAutoCommit(Connection conn, boolean autoCommit) {
        Preconditions.checkArgument((conn != null ? 1 : 0) != 0, (Object)"Connection is null");
        try {
            conn.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            if (JvmArgs.isDebugable) {
                log.warn("setAutoCommit failed", (Throwable)e);
            }
            log.warn("setAutoCommit failed. Error: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
        }
        JdbcUtils.execute(conn, autoCommit ? OPEN_AUTOCOMMIT : CLOSE_AUTOCOMMIT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean execute(Connection conn, String sql) {
        Preconditions.checkArgument((conn != null ? 1 : 0) != 0, (Object)"Connection is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(sql), (Object)"Input sql is null");
        Stopwatch stopwatch = null;
        if (log.isDebugEnabled()) {
            stopwatch = Stopwatch.createStarted();
        }
        try (Statement stmt = conn.createStatement();){
            stmt.execute(sql);
            if (log.isDebugEnabled()) {
                log.debug("Execute success. ({}) SQL: {}", (Object)stopwatch, (Object)sql);
            }
            boolean throwable3 = true;
            return throwable3;
        }
        catch (Exception ex) {
            String msg = ExceptionUtils.getRootCauseMessage(ex);
            if (msg.contains("Access denied")) {
                throw new RuntimeException("Execute failed. SQL: " + sql + "", org.apache.commons.lang3.exception.ExceptionUtils.getRootCause((Throwable)ex));
            }
            log.warn("Execute failed. SQL: {}. Error: {}", new Object[]{sql, msg, org.apache.commons.lang3.exception.ExceptionUtils.getRootCause((Throwable)ex)});
            return false;
        }
    }

    public static boolean isStatementSyntaxError(String error) {
        return org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)error, (CharSequence)"SQL syntax") || org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)error, (CharSequence)"syntax error") || org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)error, (CharSequence)"Unknown character set");
    }

    public static boolean isExecuteTimeoutError(Throwable th, String error) {
        return th instanceof TimeoutException || org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)error, (CharSequence)"timeout");
    }

    public static boolean isCreateExistsObjectError(String sql, String error) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(sql), (Object)"sql is null");
        return org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)error, (CharSequence)"database exists") || org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)error, (CharSequence)"already exist") || org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)error, (CharSequence)"already used by an existing object");
    }

    public static boolean isCreateWithoutDependenciesError(String error) {
        return org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)error, (CharSequence)"does not exist") || org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)error, (CharSequence)"doesn't exist");
    }

    public static boolean isDropSql(String sql) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(sql), (Object)"sql is null");
        return sql.length() > 5 && StringUtils.equalsIgnoreCase("drop", sql.trim().substring(0, 4));
    }

    public static boolean isDropNonExistsObjectError(String sql, String msg) {
        return JdbcUtils.isDropSql(sql) && (org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)msg, (CharSequence)"Unknown table") || org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)msg, (CharSequence)"does not exist") || org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)msg, (CharSequence)"is not VIEW"));
    }

    public static boolean isInsertSql(String sql) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(sql), (Object)"sql is null");
        return sql.length() > 6 && StringUtils.equalsIgnoreCase("insert", sql.trim().substring(0, 6));
    }

    public static boolean isInsertDuplicateKeyError(String sql, String error) {
        return JdbcUtils.isInsertSql(sql) && (org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)error, (CharSequence)"Duplicate entry") || org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)error, (CharSequence)"unique constraint"));
    }

    public static String removeIncompatibleSnippet(String sql) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(sql), (Object)"sql is null");
        int len = sql.length();
        int tokenCount = 0;
        StringBuilder token = new StringBuilder(16);
        StringBuilder objectType = new StringBuilder(16);
        for (int i = 0; i < len; ++i) {
            char ch = sql.charAt(i);
            if (ch != ' ') {
                token.append(ch);
                continue;
            }
            if (token.length() <= 0) continue;
            if (++tokenCount == 1 && StringUtils.notEqualsIgnoreCase("create", token)) {
                return sql;
            }
            if (tokenCount > 5) {
                return sql;
            }
            if (StringUtils.equalsIgnoreCase("if", token)) {
                objectType.append(sql, 0, i - 2);
                continue;
            }
            if (StringUtils.equalsIgnoreCase("exists", token)) {
                return objectType + sql.substring(i);
            }
            if (StringUtils.equalsIgnoreCase("replace", token)) {
                return "create" + sql.substring(i);
            }
            token.setLength(0);
        }
        return sql;
    }
}

