/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.utils;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoPool;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializeUtils {
    private static final Logger log = LoggerFactory.getLogger(SerializeUtils.class);
    private static final KryoPool KRYO_POOL = new KryoPool.Builder(() -> {
        Kryo kryo = new Kryo();
        kryo.setReferences(true);
        kryo.setRegistrationRequired(false);
        return kryo;
    }).softReferences().build();

    private SerializeUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void serializeObjectByKryo(T obj, String path) throws Exception {
        FileUtils.touch((File)new File(path));
        Kryo kryo = KRYO_POOL.borrow();
        try (Output output = new Output(Files.newOutputStream(Paths.get(path, new String[0]), new OpenOption[0]));){
            kryo.writeClassAndObject(output, obj);
            output.flush();
        }
        finally {
            KRYO_POOL.release(kryo);
        }
    }

    public static <T> T deserializeObjectByKryo(String path) throws Exception {
        if (!new File(path).exists()) {
            throw new FileNotFoundException("File: \"{" + path + "}\" is not exists");
        }
        return SerializeUtils.deserializeObjectByKryo(Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static <T> T deserializeObjectByKryo(InputStream inputStream) {
        Object object;
        Throwable throwable;
        Input input;
        Kryo kryo;
        block16: {
            block17: {
                kryo = KRYO_POOL.borrow();
                input = new Input(inputStream);
                throwable = null;
                object = kryo.readClassAndObject(input);
                if (input == null) break block16;
                if (throwable == null) break block17;
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block16;
            }
            input.close();
        }
        KRYO_POOL.release(kryo);
        return (T)object;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (input != null) {
                                if (throwable != null) {
                                    try {
                                        input.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    input.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (Exception e) {
                        log.warn("Failed to deserialize object. Reason: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
                        KRYO_POOL.release(kryo);
                    }
                }
                catch (Throwable throwable6) {
                    KRYO_POOL.release(kryo);
                    throw throwable6;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void serializeListByKryo(List<T> list, String path) throws Exception {
        FileUtils.touch((File)new File(path));
        Kryo kryo = KRYO_POOL.borrow();
        try (Output output = new Output(Files.newOutputStream(Paths.get(path, new String[0]), new OpenOption[0]));){
            kryo.writeClassAndObject(output, list);
            output.flush();
        }
        finally {
            KRYO_POOL.release(kryo);
        }
    }

    public static <T> List<T> deserializeListByKryo(String path) throws Exception {
        if (!new File(path).exists()) {
            throw new FileNotFoundException("File: \"" + path + "\" is not exists");
        }
        List returnVal = (List)SerializeUtils.deserializeObjectByKryo(Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]));
        return returnVal == null ? new ArrayList() : returnVal;
    }
}

