/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file.hdfs;

import com.oceanbase.tools.loaddump.common.model.storage.remote.hdfs.HdfsStorageConfig;
import com.oceanbase.tools.loaddump.writer.file.hdfs.HdfsFlatFileWriter;

public class HdfsSqlFileWriter
extends HdfsFlatFileWriter {
    private static final String COMMIT_STMT = "commit;" + System.lineSeparator();
    private int commitSize;

    public HdfsSqlFileWriter(String filePath, String fileName, String fileSuffix, String fileEncoding, long blockSize, int blockRow, int participant, int commitSize, HdfsStorageConfig conf) {
        super(filePath, fileName, fileSuffix, fileEncoding, blockSize, blockRow, participant, conf);
        this.commitSize = commitSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(Object line) throws Exception {
        this.lock.lock();
        try {
            long byteSize = super.write(line);
            if (this.currentBlockRowCnt % (long)this.commitSize == 0L) {
                this.writeInternal(COMMIT_STMT);
            }
            long l = byteSize;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public static class Builder
    extends HdfsFlatFileWriter.Builder {
        int commitSize;

        public Builder commitSize(int commitSize) {
            this.commitSize = commitSize;
            return this;
        }

        @Override
        public HdfsSqlFileWriter build() {
            return new HdfsSqlFileWriter(this.filePath, this.fileName, this.fileSuffix, this.fileEncoding, this.blockSize, this.blockRow, this.participant, this.commitSize, this.storageConfig);
        }
    }
}

