/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file.local;

import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingFileWriterV2;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class FlatFileWriterV2
extends AbstractRollingFileWriterV2 {
    protected BufferedWriter bw;
    protected final String fileEncoding;

    public FlatFileWriterV2(String filePath, String fileName, String fileSuffix, String fileEncoding, long blockSize, int blockRow, int participant) {
        super(filePath, fileName, fileSuffix, blockSize, blockRow, participant);
        this.fileEncoding = fileEncoding;
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        if (this.bw != null) {
            this.bw.close();
            this.bw = null;
        }
        this.closed = true;
    }

    @Override
    protected long writeInternal(Object line) throws Exception {
        if (this.bw == null) {
            this.bw = this.createBufferWriter();
        }
        if (line == null) {
            return 0L;
        }
        String raw = line.toString();
        this.bw.write(raw);
        return raw.getBytes().length;
    }

    @Override
    protected void rollover() throws Exception {
        super.rollover();
        this.bw.close();
        this.bw = null;
    }

    protected BufferedWriter createBufferWriter() throws IOException {
        if (!FileUtils.exists(this.currentFilePath)) {
            FileUtils.touch((File)new File(this.currentFilePath));
        }
        OutputStream os = Files.newOutputStream(Paths.get(this.currentFilePath, new String[0]), new OpenOption[0]);
        return new BufferedWriter(new OutputStreamWriter(os, this.fileEncoding), 0x100000);
    }

    public static class Builder
    extends AbstractRollingFileWriterV2.Builder {
        protected String fileEncoding;

        public Builder fileEncoding(String fileEncoding) {
            this.fileEncoding = fileEncoding;
            return this;
        }

        @Override
        public AbstractRollingFileWriterV2 build() {
            return new FlatFileWriterV2(this.filePath, this.fileName, this.fileSuffix, this.fileEncoding, this.blockSize, this.blockRow, this.participant);
        }
    }
}

