/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file.local;

import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingFileWriterV2;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcFileWriterV2
extends AbstractRollingFileWriterV2
implements Flushable {
    private static final Logger log = LoggerFactory.getLogger(OrcFileWriterV2.class);
    private Writer orcWriter;
    private final Configuration conf;
    private final TypeDescription schema;
    private VectorizedRowBatch batch;
    private ColumnValueSetter[] columnValueSetters;

    public OrcFileWriterV2(String filePath, String fileName, String fileSuffix, long blockSize, int blockRow, int participant, Configuration conf, TypeDescription schema) {
        super(filePath, fileName, fileSuffix, blockSize, blockRow, participant);
        this.conf = conf;
        this.schema = schema;
        this.initColumnValueSetters(schema);
    }

    @Override
    protected long writeInternal(Object line) throws Exception {
        if (this.orcWriter == null) {
            this.initWriter();
        }
        String[] rowValues = (String[])line;
        int rowIdx = this.batch.size++;
        long byteSize = 0L;
        for (int i = 0; i < this.columnValueSetters.length; ++i) {
            String value = rowValues[i];
            ColumnVector vec = this.batch.cols[i];
            if (value == null) {
                vec.isNull[rowIdx] = true;
                vec.noNulls = false;
                continue;
            }
            this.columnValueSetters[i].setValue(this.batch.cols[i], rowIdx, rowValues[i]);
            byteSize += (long)value.length();
        }
        if (this.batch.size == this.batch.getMaxSize()) {
            this.flush();
        }
        return byteSize;
    }

    @Override
    public void flush() throws IOException {
        this.orcWriter.addRowBatch(this.batch);
        this.batch.reset();
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        if (this.orcWriter != null) {
            this.flush();
            this.batch = null;
            this.orcWriter.close();
            this.orcWriter = null;
        }
        this.closed = true;
    }

    private void initWriter() throws Exception {
        this.orcWriter = this.createOrcWriterV2();
        this.batch = this.orcWriter.getSchema().createRowBatchV2();
    }

    @Override
    protected void rollover() throws Exception {
        super.rollover();
        this.flush();
        this.orcWriter.close();
        this.orcWriter = null;
        this.batch = null;
    }

    private void initColumnValueSetters(TypeDescription schema) {
        int colNum = schema.getChildren().size();
        this.columnValueSetters = new ColumnValueSetter[colNum];
        block6: for (int i = 0; i < colNum; ++i) {
            TypeDescription type = (TypeDescription)schema.getChildren().get(i);
            switch (type.getCategory()) {
                case LONG: {
                    this.columnValueSetters[i] = (vec, rowIdx, value) -> {
                        ((LongColumnVector)vec).vector[rowIdx] = Long.parseLong(value);
                    };
                    continue block6;
                }
                case DOUBLE: {
                    this.columnValueSetters[i] = (vec, rowIdx, value) -> {
                        ((DoubleColumnVector)vec).vector[rowIdx] = Double.parseDouble(value);
                    };
                    continue block6;
                }
                case DECIMAL: {
                    this.columnValueSetters[i] = (vec, rowIdx, value) -> ((DecimalColumnVector)vec).set(rowIdx, HiveDecimal.create((String)value));
                    continue block6;
                }
                case BOOLEAN: {
                    this.columnValueSetters[i] = (vec, rowIdx, value) -> {
                        ((LongColumnVector)vec).vector[rowIdx] = Boolean.parseBoolean(value) ? 1L : 0L;
                    };
                    continue block6;
                }
                default: {
                    this.columnValueSetters[i] = (vec, rowIdx, value) -> ((BytesColumnVector)vec).setVal(rowIdx, this.getBytes(value, "UTF-8"));
                }
            }
        }
    }

    Writer createOrcWriterV2() throws Exception {
        if (!FileUtils.exists(this.currentFilePath)) {
            FileUtils.touch((File)new File(this.currentFilePath));
        }
        this.conf.setDouble(OrcConf.MEMORY_POOL.getAttribute(), 0.5);
        this.conf.set(OrcConf.COMPRESSION_STRATEGY.getAttribute(), OrcFile.CompressionStrategy.COMPRESSION.name());
        this.conf.setInt(OrcConf.ROW_BATCH_SIZE.getAttribute(), 2048);
        this.conf.set(OrcConf.DICTIONARY_IMPL.getAttribute(), "hash");
        this.conf.set(OrcConf.ROWS_BETWEEN_CHECKS.getAttribute(), String.valueOf(1000));
        return OrcFile.createWriter((Path)new Path(this.currentFilePath), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).setSchema(this.schema).overwrite(true).bufferSize(262144).stripeSize(0x4000000L).blockSize(0x20000000L).encodingStrategy(OrcFile.EncodingStrategy.COMPRESSION).compress(CompressionKind.ZSTD).version(OrcFile.Version.V_0_12));
    }

    public static class Builder
    extends AbstractRollingFileWriterV2.Builder {
        private Configuration conf;
        private Map<String, Object> columnTypeMap;

        public Builder() {
            this.fileSuffix = DataFormat.ORC.getDefaultFileSuffix();
            this.conf = new Configuration();
            this.conf.set("fs.file.impl", "org.apache.hadoop.fs.LocalFileSystem");
            this.conf.set("fs.defaultFS", "file:///");
        }

        public Builder conf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder columnTypeMap(Map<String, Object> columnTypeMap) {
            this.columnTypeMap = columnTypeMap;
            return this;
        }

        static TypeDescription assembleTypeDescription(Object dataTypeObj) {
            String dataType = dataTypeObj.toString();
            int index = (dataType = dataType.trim().toLowerCase(Locale.getDefault())).indexOf("unsigned");
            switch (dataType = index > -1 ? dataType.substring(0, index).trim() : dataType) {
                case "bool": 
                case "boolean": {
                    return TypeDescription.createBoolean();
                }
                case "int": 
                case "integer": 
                case "tinyint": 
                case "smallint": 
                case "bigint": {
                    return TypeDescription.createLong();
                }
                case "float": 
                case "double": {
                    return TypeDescription.createDouble();
                }
                case "number": 
                case "numeric": 
                case "real": 
                case "decimal": 
                case "bigdecimal": 
                case "binary_float": 
                case "binary_double": {
                    return TypeDescription.createDecimal();
                }
                case "bit": 
                case "raw": 
                case "longraw": 
                case "binary": 
                case "varbinary": 
                case "longvarbinary": 
                case "tinyblob": 
                case "blob": 
                case "mediumblob": 
                case "clob": 
                case "nclob": 
                case "longblob": {
                    return TypeDescription.createBinary();
                }
            }
            return TypeDescription.createString();
        }

        @Override
        public OrcFileWriterV2 build() {
            TypeDescription schema = TypeDescription.createStruct();
            this.columnTypeMap.forEach((columnName, columnType) -> schema.addField(columnName, Builder.assembleTypeDescription(columnType)));
            return new OrcFileWriterV2(this.filePath, this.fileName, this.fileSuffix, this.blockSize, this.blockRow, this.participant, this.conf, schema);
        }
    }

    static interface ColumnValueSetter {
        public void setValue(ColumnVector var1, int var2, String var3) throws Exception;
    }
}

