/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file.local;

import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingFileWriterV2;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetFileWriterV2
extends AbstractRollingFileWriterV2 {
    private static final Logger log = LoggerFactory.getLogger(ParquetFileWriterV2.class);
    private final Configuration conf;
    private final MessageType schema;
    private ParquetWriter<Group> writer;
    private ColumnValueSetter[] columnValueSetters;

    public ParquetFileWriterV2(Configuration conf, MessageType schema, String filePath, String fileName, String fileSuffix, long blockSize, int blockRow, int participant) {
        super(filePath, fileName, fileSuffix, blockSize, blockRow, participant);
        this.schema = schema;
        this.conf = conf;
        this.initColumnValueSetters(schema);
    }

    @Override
    protected long writeInternal(Object line) throws Exception {
        if (this.writer == null) {
            this.writer = this.createParquetWriter();
        }
        long byteSize = 0L;
        SimpleGroup group = new SimpleGroup((GroupType)this.schema);
        String[] row = (String[])line;
        for (int i = 0; i < this.columnValueSetters.length; ++i) {
            String value = row[i];
            if (value == null) continue;
            this.columnValueSetters[i].setValue((Group)group, i, value);
            byteSize += (long)value.length();
        }
        this.writer.write((Object)group);
        return byteSize;
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
            this.closed = true;
        }
    }

    @Override
    protected void rollover() throws Exception {
        super.rollover();
        this.writer.close();
        this.writer = null;
    }

    private void initColumnValueSetters(MessageType schema) {
        int colNum = schema.getFields().size();
        this.columnValueSetters = new ColumnValueSetter[colNum];
        block6: for (int i = 0; i < colNum; ++i) {
            Type type = (Type)schema.getFields().get(i);
            switch (type.asPrimitiveType().getPrimitiveTypeName()) {
                case INT32: {
                    this.columnValueSetters[i] = (group, offset, value) -> group.add(offset, Integer.parseInt(value));
                    continue block6;
                }
                case INT64: {
                    this.columnValueSetters[i] = (group, offset, value) -> group.add(offset, Long.parseLong(value));
                    continue block6;
                }
                case BOOLEAN: {
                    this.columnValueSetters[i] = (group, offset, value) -> group.add(offset, Boolean.parseBoolean(value));
                    continue block6;
                }
                case DOUBLE: {
                    this.columnValueSetters[i] = (group, offset, value) -> group.add(offset, Double.parseDouble(value));
                    continue block6;
                }
                default: {
                    this.columnValueSetters[i] = Group::add;
                }
            }
        }
    }

    ParquetWriter<Group> createParquetWriter() throws Exception {
        if (!FileUtils.exists(this.currentFilePath)) {
            FileUtils.touch((File)new File(this.currentFilePath));
        }
        return ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)new Path(this.currentFilePath)).withType(this.schema).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withWriterVersion(ParquetProperties.WriterVersion.PARQUET_2_0)).withBloomFilterEnabled(false)).withConf(this.conf)).withCompressionCodec(CompressionCodecName.ZSTD)).withDictionaryEncoding(true)).withPageWriteChecksumEnabled(false)).build();
    }

    public static class Builder
    extends AbstractRollingFileWriterV2.Builder {
        private MessageType schema;
        private Configuration conf;

        public Builder() {
            this.fileSuffix = DataFormat.PAR.getDefaultFileSuffix();
            this.conf = new Configuration();
            this.conf.set("fs.file.impl", "org.apache.hadoop.fs.LocalFileSystem");
            this.conf.set("fs.defaultFS", "file:///");
        }

        public Builder conf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder columnTypeMap(String schemaName, Map<String, Object> colTypeMap) {
            Types.MessageTypeBuilder mtb = Types.buildMessage();
            colTypeMap.forEach((columnName, columnType) -> {
                Types.GroupBuilder cfr_ignored_0 = (Types.GroupBuilder)mtb.addField(Builder.getMappedPrimitiveType(columnName, columnType));
            });
            this.schema = mtb.named(schemaName);
            return this;
        }

        static Type getMappedPrimitiveType(String columnName, Object columnType) {
            String dataType = columnType.toString();
            int index = (dataType = dataType.trim().toLowerCase(Locale.getDefault())).indexOf("unsigned");
            switch (dataType = index > -1 ? dataType.substring(0, index).trim() : dataType) {
                case "int": 
                case "integer": 
                case "tinyint": 
                case "smallint": {
                    return (Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named(columnName);
                }
                case "bigint": {
                    return (Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named(columnName);
                }
                case "float": 
                case "double": {
                    return (Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE).named(columnName);
                }
                case "bool": 
                case "boolean": {
                    return (Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN).named(columnName);
                }
            }
            return (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(columnName);
        }

        @Override
        public ParquetFileWriterV2 build() {
            return new ParquetFileWriterV2(this.conf, this.schema, this.filePath, this.fileName, this.fileSuffix, this.blockSize, this.blockRow, this.participant);
        }
    }

    static interface ColumnValueSetter {
        public void setValue(Group var1, int var2, String var3) throws Exception;
    }
}

