/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file.local;

import com.oceanbase.tools.loaddump.writer.file.local.FlatFileWriterV2;

public class SqlFileWriter
extends FlatFileWriterV2 {
    private static final String COMMIT_STMT = "commit;" + System.lineSeparator();
    private int commitSize;

    public SqlFileWriter(String filePath, String fileName, String fileSuffix, String fileEncoding, long blockSize, int blockRow, int participant, int commitSize) {
        super(filePath, fileName, fileSuffix, fileEncoding, blockSize, blockRow, participant);
        this.commitSize = commitSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(Object line) throws Exception {
        this.lock.lock();
        try {
            long byteSize = super.write(line);
            if (this.currentBlockRowCnt % (long)this.commitSize == 0L) {
                this.writeInternal(COMMIT_STMT);
            }
            long l = byteSize;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public static class Builder
    extends FlatFileWriterV2.Builder {
        int commitSize;

        public Builder commitSize(int commitSize) {
            this.commitSize = commitSize;
            return this;
        }

        @Override
        public SqlFileWriter build() {
            return new SqlFileWriter(this.filePath, this.fileName, this.fileSuffix, this.fileEncoding, this.blockSize, this.blockRow, this.participant, this.commitSize);
        }
    }
}

