/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file.oss;

import com.aliyun.oss.OSS;
import com.aliyun.oss.model.AppendObjectRequest;
import com.aliyun.oss.model.AppendObjectResult;
import com.aliyun.oss.model.PutObjectRequest;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.OssStorageConfig;
import com.oceanbase.tools.loaddump.factory.ClientFactory;
import com.oceanbase.tools.loaddump.vmoption.JvmArgs;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingFileWriterV2;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssFlatFileWriter
extends AbstractRollingFileWriterV2 {
    private static final Logger log = LoggerFactory.getLogger(OssFlatFileWriter.class);
    private static final int BUFFER_SIZE = OssFlatFileWriter.computeMemBufferSize();
    protected OssStorageConfig storageConfig;
    protected final String fileEncoding;
    private OSS ossClient;
    private long nextPosition;
    private ByteBuffer buffer;

    public OssFlatFileWriter(String filePath, String fileName, String fileSuffix, String fileEncoding, long blockSize, int blockRow, int participant, OssStorageConfig storageConfig) {
        super(filePath, fileName, fileSuffix, blockSize, blockRow, participant);
        this.storageConfig = storageConfig;
        this.fileEncoding = fileEncoding;
        this.ossClient = ClientFactory.createOssClient(storageConfig);
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        if (this.buffer != null) {
            this.buffer = null;
        }
        this.ossClient.shutdown();
        this.ossClient = null;
        this.closed = true;
    }

    @Override
    protected long writeInternal(Object line) throws Exception {
        if (this.currentBlockSize == 0L) {
            this.nextPosition = 0L;
        }
        byte[] raw = line.toString().getBytes();
        if (this.buffer == null) {
            this.buffer = ByteBuffer.allocate(BUFFER_SIZE);
        }
        if (this.buffer.position() + raw.length < BUFFER_SIZE) {
            this.buffer.put(raw);
            return raw.length;
        }
        this.flush();
        if (raw.length > BUFFER_SIZE) {
            this.buffer.clear();
            this.buffer = ByteBuffer.allocate(raw.length + BUFFER_SIZE);
        }
        this.buffer.put(raw);
        return raw.length;
    }

    @Override
    protected void rollover() throws Exception {
        this.flush();
        super.rollover();
    }

    @Override
    public void createEmpty() throws IOException {
        String objectKey = this.storageConfig.assembleDestPath(new File(this.currentFilePath));
        PutObjectRequest req = new PutObjectRequest(this.storageConfig.getBucket(), objectKey, (InputStream)new ByteArrayInputStream(new byte[0]));
        try {
            this.ossClient.putObject(req);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void finishOff() throws Exception {
        this.flush();
        super.finishOff();
    }

    private void flush() throws IOException {
        if (this.buffer == null || this.buffer.position() == 0) {
            return;
        }
        byte[] data = new byte[this.buffer.position()];
        System.arraycopy(this.buffer.array(), 0, data, 0, this.buffer.position());
        this.buffer.clear();
        File currentFile = new File(this.currentFilePath);
        String objectKey = this.storageConfig.assembleDestPath(currentFile);
        String bucketName = this.storageConfig.getBucket();
        try {
            if (this.nextPosition == 0L && this.ossClient.doesObjectExist(bucketName, objectKey)) {
                this.ossClient.deleteObject(bucketName, objectKey);
            }
            AppendObjectRequest appendObjectRequest = new AppendObjectRequest(bucketName, objectKey, (InputStream)new ByteArrayInputStream(data)).withPosition(Long.valueOf(this.nextPosition));
            AppendObjectResult appendObjectResult = this.ossClient.appendObject(appendObjectRequest);
            this.nextPosition = appendObjectResult.getNextPosition();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static int computeMemBufferSize() {
        if (JvmArgs.writeMemoryBuffer > 0) {
            return JvmArgs.writeMemoryBuffer;
        }
        long maxMem = Runtime.getRuntime().maxMemory();
        if (maxMem < 0x40000000L) {
            return 0x800000;
        }
        if (maxMem <= 0x100000000L) {
            return 0x1000000;
        }
        if (maxMem <= 0x200000000L) {
            return 0x2000000;
        }
        return 0x4000000;
    }

    public static class Builder
    extends AbstractRollingFileWriterV2.Builder {
        protected String fileEncoding;
        protected OssStorageConfig storageConfig;

        public Builder fileEncoding(String fileEncoding) {
            this.fileEncoding = fileEncoding;
            return this;
        }

        public Builder storageConfig(OssStorageConfig storageConfig) {
            this.storageConfig = storageConfig;
            return this;
        }

        @Override
        public OssFlatFileWriter build() {
            return new OssFlatFileWriter(this.filePath, this.fileName, this.fileSuffix, this.fileEncoding, this.blockSize, this.blockRow, this.participant, this.storageConfig);
        }
    }
}

