/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file.oss;

import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.OssStorageConfig;
import com.oceanbase.tools.loaddump.writer.file.oss.OssFlatFileWriter;

public class OssSqlFileWriter
extends OssFlatFileWriter {
    private static final String COMMIT_STMT = "commit;" + System.lineSeparator();
    private int commitSize;

    public OssSqlFileWriter(String filePath, String fileName, String fileSuffix, String fileEncoding, long blockSize, int blockRow, int participant, int commitSize, OssStorageConfig storageConfig) {
        super(filePath, fileName, fileSuffix, fileEncoding, blockSize, blockRow, participant, storageConfig);
        this.commitSize = commitSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(Object line) throws Exception {
        this.lock.lock();
        try {
            long byteSize = super.write(line);
            if (this.currentBlockRowCnt % (long)this.commitSize == 0L) {
                this.currentBlockSize += this.writeInternal(COMMIT_STMT);
            }
            long l = byteSize;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public static class Builder
    extends OssFlatFileWriter.Builder {
        int commitSize;

        public Builder commitSize(int commitSize) {
            this.commitSize = commitSize;
            return this;
        }

        @Override
        public OssSqlFileWriter build() {
            return new OssSqlFileWriter(this.filePath, this.fileName, this.fileSuffix, this.fileEncoding, this.blockSize, this.blockRow, this.participant, this.commitSize, this.storageConfig);
        }
    }
}

