/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file.s3;

import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.Upload;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.S3StorageConfig;
import com.oceanbase.tools.loaddump.factory.ClientFactory;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingFileWriterV2;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingUploadWriter;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3RollingUploadWriter
extends AbstractRollingUploadWriter {
    private static final Logger log = LoggerFactory.getLogger(S3RollingUploadWriter.class);
    private final S3StorageConfig storageConfig;
    private AbstractRollingFileWriterV2 localFileWriter;
    private TransferManager tm;

    public S3RollingUploadWriter(AbstractRollingFileWriterV2 localFileWriter, S3StorageConfig storageConfig) {
        super(localFileWriter);
        this.storageConfig = storageConfig;
        this.tm = ClientFactory.createS3TransferManager(storageConfig);
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        if (this.localFileWriter != null) {
            this.localFileWriter.close();
            this.localFileWriter = null;
        }
        this.tm.shutdownNow();
        this.tm = null;
        this.closed = true;
    }

    @Override
    protected void upload() throws IOException {
        File currentFile = new File(this.currentFilePath);
        String objectKey = this.storageConfig.assembleDestPath(new File(this.currentFilePath));
        PutObjectRequest req = new PutObjectRequest(this.storageConfig.getBucket(), objectKey, currentFile);
        req.setStorageClass(this.storageConfig.getStorageClass());
        log.info("Uploading \"{}\" ...", (Object)this.currentFilePath);
        try {
            Upload upload = this.tm.upload(req);
            upload.waitForCompletion();
            try {
                FileUtils.forceDelete((File)currentFile);
            }
            catch (IOException e) {
                log.warn("Failed to delete local file \"{}\". Reason: {}", (Object)this.currentFilePath, (Object)e);
            }
        }
        catch (Exception e) {
            log.error("Upload \"{}\" failed, local file will not be deleted. Error: {}", (Object)this.currentFilePath, (Object)e);
        }
    }
}

