/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.client;

import com.alibaba.druid.pool.DruidPooledStatement;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.oceanbase.jdbc.OceanBaseStatement;
import com.oceanbase.tools.loaddump.base.State;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.model.AdvancedOption;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.Database;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.Summary;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.common.model.TaskDetail;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.concurrent.ExecutorTemplate;
import com.oceanbase.tools.loaddump.factory.ResourceFinderFactory;
import com.oceanbase.tools.loaddump.jdbc.JdbcExecutor;
import com.oceanbase.tools.loaddump.manager.SessionManager;
import com.oceanbase.tools.loaddump.resource.Resource;
import com.oceanbase.tools.loaddump.resource.ResourceFinder;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import com.oceanbase.tools.loaddump.utils.TimeUtils;
import java.io.Closeable;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadDataInfileClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(LoadDataInfileClient.class);
    private static final String GET_SECURE_FILE_DIR = "show variables like 'secure_file_priv'";
    private static final String LOAD_DATA_SQL = "LOAD DATA {0} INFILE {1} INTO TABLE {2} FIELDS TERMINATED BY {3} OPTIONALLY ENCLOSED BY {4} LINES TERMINATED BY {5}";
    protected State state;
    protected final LoadParameter parameter;
    protected Map<String, TableInfo> tableMap;
    protected boolean closed;
    protected ConnectionKey connectionKey;

    private LoadDataInfileClient(LoadParameter parameter) {
        this.parameter = parameter;
        ThreadContext.put((String)"task.workspace", (String)parameter.getLogsPath());
    }

    public int loadRecord() {
        this.filterTablesWithDataFilesIfNecessary();
        this.truncateTableIfNecessary();
        List<TaskDetail> taskDetails = this.loadInternal();
        log.info(new Summary("All Remote Load Tasks Finished", taskDetails).toHumanReadableFormat());
        return taskDetails.stream().allMatch(TaskDetail::isSuccess) ? 0 : 1;
    }

    private void truncateTableIfNecessary() {
        if (!this.parameter.isTruncatable() && !this.parameter.isDeleteable()) {
            log.info("Ignore to clean any tables as --truncate-table or --delete-from-table is not specified");
            return;
        }
        ConnectionKey connectionKey = this.parameter.getConnectionKey();
        connectionKey.getMetadataProvider().markEmptyTables(connectionKey.getServerMode().isOracleMode(), this.tableMap);
        HashSet tableInfoCopies = Sets.newHashSet(this.tableMap.values());
        AtomicLong remain = new AtomicLong(tableInfoCopies.size());
        Iterator iter = tableInfoCopies.iterator();
        while (iter.hasNext()) {
            TableInfo tableInfo = (TableInfo)iter.next();
            if (!tableInfo.isEmptyTable()) continue;
            log.info("Ignore to clean the empty table: {}. Remain: {}", (Object)tableInfo.getSchemaTable(), (Object)remain);
            iter.remove();
            remain.decrementAndGet();
        }
        if (remain.get() <= 0L) {
            log.info("No tables should be truncated.");
            return;
        }
        ExecutorTemplate template = new ExecutorTemplate("truncate-table-");
        for (TableInfo tableInfoCopy : tableInfoCopies) {
            template.submit(() -> {
                String ddl = this.parameter.isTruncatable() ? "truncate table " + tableInfoCopy.getSchemaTable() : "delete from " + tableInfoCopy.getSchemaTable();
                try (Connection conn = connectionKey.getSessionManager().getPooledBizConnection();
                     PreparedStatement ps = conn.prepareStatement(ddl);){
                    Stopwatch elapsed = Stopwatch.createStarted();
                    ps.execute();
                    remain.decrementAndGet();
                    log.info("Exec {} finished. Elapsed: {}. Remain: {}", new Object[]{ddl, elapsed.stop(), remain});
                }
                catch (Exception e) {
                    log.error("Exec {} failed. Error: {}", (Object)ddl, (Object)ExceptionUtils.getRootCauseMessage(e));
                }
            });
        }
        template.waitForResult();
        int refreshTime = tableInfoCopies.size() > 10 ? 10000 : 5000;
        TimeUtils.sleep(TimeUnit.MILLISECONDS, refreshTime);
        log.info("Wait {} ms for observer to refresh schema finished", (Object)refreshTime);
    }

    private void filterTablesWithDataFilesIfNecessary() {
        if (!this.parameter.isTruncateWithDataFile()) {
            return;
        }
        ResourceFinder<Resource> resourceFinder = ResourceFinderFactory.createResourceFinder(this.parameter);
        List<Resource> resources = null;
        try {
            resources = resourceFinder.listRecordResources();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        File file = new File(this.parameter.getFilePath());
        if (file.isFile()) {
            Set<String> tableNames = this.tableMap.keySet();
            Preconditions.checkArgument((tableNames.size() == 1 ? 1 : 0) != 0, (String)"Specified table count=(%s) is unexpected. As -f/--file is a file.", (int)tableNames.size());
            Preconditions.checkArgument((resources.size() == 1 ? 1 : 0) != 0, (String)"Searched resource count=(%s) is unexpected. As -f/--file is a file.", (int)resources.size());
            return;
        }
        HashMap ignoredTables = Maps.newHashMap(this.tableMap);
        this.tableMap = resources.stream().map(Resource::getObjectName).distinct().filter(t -> this.tableMap.containsKey(t)).collect(Collectors.toMap(Function.identity(), t -> this.tableMap.get(t)));
        ignoredTables.keySet().removeAll(this.tableMap.keySet());
        if (MapUtils.isNotEmpty((Map)ignoredTables)) {
            log.info("Ignore to truncate tables without data files: {}", (Object)ignoredTables.values().stream().map(t -> "\n - " + t.getSchemaTable()).collect(Collectors.joining("")));
        }
    }

    private List<TaskDetail> loadInternal() {
        boolean isFile;
        ConnectionKey connectionKey = this.parameter.getConnectionKey();
        SessionManager sessionManager = connectionKey.getSessionManager();
        String path = this.parameter.getFilePath();
        boolean bl = isFile = path.endsWith(".csv") || path.endsWith(".txt") || path.endsWith(".dat");
        if (isFile && this.tableMap.size() != 1) {
            throw new IllegalArgumentException("File name does not match the table count");
        }
        ArrayList<String> hints = new ArrayList<String>();
        if (this.parameter.getParallel() > 0) {
            hints.add("parallel(" + this.parameter.getParallel() + ")");
        }
        if (this.parameter.isDirectMode()) {
            hints.add("direct(true, 0)");
        }
        String hintStr = hints.size() > 0 ? "/*+ " + StringUtils.join(hints.toArray(new String[0]), " ") + " */" : "";
        ExecutorTemplate<TaskDetail> template = new ExecutorTemplate<TaskDetail>("remote-load-", this.parameter.getThreads());
        for (TableInfo tableInfo : this.tableMap.values()) {
            String tableName = tableInfo.getTable();
            String realFilePath = isFile ? path : FileUtils.toPath(path, tableName + ".csv");
            String sql = MessageFormat.format(LOAD_DATA_SQL, hintStr, StringUtils.wrapWithQuot(realFilePath), connectionKey.getServerMode().wrapName(tableName), StringUtils.wrapWithQuot(this.parameter.getColumnSeparator()), StringUtils.wrapWithQuot(this.parameter.getColumnDelimiter()), StringUtils.wrapWithQuot(StringEscapeUtils.escapeJava((String)this.parameter.getLineSeparator())));
            template.submit(() -> {
                TaskDetail taskDetail = new TaskDetail();
                taskDetail.setSchema(connectionKey.getDatabase());
                taskDetail.setObject(tableName);
                taskDetail.setType(ObjectType.TABLE.getName());
                try (Connection conn = sessionManager.getPooledBizConnection();){
                    DruidPooledStatement druidStmt = (DruidPooledStatement)conn.createStatement();
                    OceanBaseStatement obStmt = (OceanBaseStatement)druidStmt.getStatement();
                    log.info("Execute SQL: {}", (Object)sql);
                    obStmt.execute(sql);
                    int updateCount = obStmt.getUpdateCount();
                    taskDetail.setCount(updateCount);
                    if (StringUtils.isNotBlank(obStmt.getServerInfo())) {
                        int[] stat = this.parseServerResp(obStmt.getServerInfo());
                        int total = stat[0];
                        taskDetail.setTotal(total);
                        taskDetail.setState(updateCount >= total ? TaskState.SUCCESS : TaskState.FAILURE);
                    } else {
                        log.warn("No detail messages received from server.");
                        taskDetail.setState(TaskState.SUCCESS);
                    }
                    log.warn("No detail messages received from server.");
                    taskDetail.setState(TaskState.SUCCESS);
                }
                catch (Exception e) {
                    if (e.toString().contains("File not exist")) {
                        log.warn("No files are available for table {}, which might be empty at the time of backup.", (Object)tableName);
                        taskDetail.setCount(0L);
                        taskDetail.setState(TaskState.SUCCESS);
                        return taskDetail;
                    }
                    taskDetail.setState(TaskState.FAILURE);
                    taskDetail.setError(ExceptionUtils.getRootCauseMessage(e));
                    log.error("Load [{}] failed!", (Object)tableName, (Object)e);
                }
                return taskDetail;
            });
        }
        return template.waitForResult();
    }

    private int[] parseServerResp(String serverResp) {
        int[] stat = new int[4];
        String[] parts = serverResp.trim().split("\\s+");
        stat[0] = Integer.parseInt(parts[1]);
        stat[1] = Integer.parseInt(parts[3]);
        stat[2] = Integer.parseInt(parts[5]);
        stat[3] = Integer.parseInt(parts[7]);
        return stat;
    }

    private void checkFilePath() {
        try {
            JdbcExecutor.query(this.parameter.getConnectionKey().getSessionManager().getPooledBizConnection(), GET_SECURE_FILE_DIR, rs -> {
                while (rs.next()) {
                    String secureDir = rs.getString(2);
                    if (secureDir.length() > 1 && secureDir.endsWith("/")) {
                        secureDir = secureDir.substring(0, secureDir.length() - 1);
                    }
                    Preconditions.checkArgument((boolean)StringUtils.startsWith((CharSequence)this.parameter.getFilePath(), (CharSequence)secureDir), (String)"Invalid value for `-f/--file-path`, which should under the path `%s`. See global system variable `secure_file_priv` for more information.", (Object)secureDir);
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (this.connectionKey != null) {
            this.connectionKey.getSessionManager().destroy();
        }
        this.closed = true;
    }

    public static class Builder {
        private LoadParameter parameter;

        public Builder parameter(LoadParameter parameter) {
            this.parameter = parameter;
            return this;
        }

        public LoadDataInfileClient build() throws Exception {
            LoadDataInfileClient target = new LoadDataInfileClient(this.parameter);
            Preconditions.checkArgument((this.parameter.getStorageConfig() == null ? 1 : 0) != 0, (Object)"Remote load only supports local file system.");
            Preconditions.checkArgument((this.parameter.getDataFormat() == DataFormat.CSV ? 1 : 0) != 0, (Object)"Remote load only supports CSV format");
            ConnectionKey connectionKey = this.parameter.buildConnectionKey();
            AdvancedOption advancedOption = new AdvancedOption(this.parameter, connectionKey.getServerMode());
            target.checkFilePath();
            List<TableInfo> tableInfoList = connectionKey.getMetadataProvider().queryTables(connectionKey, advancedOption);
            target.tableMap = tableInfoList.stream().collect(Collectors.toMap(TableInfo::getTable, Function.identity()));
            Database database = new Database();
            database.setTableInfoMap(target.tableMap);
            this.parameter.setDatabase(database);
            target.state = State.INITIAL;
            return target;
        }
    }
}

