/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.client;

import com.alibaba.druid.pool.DruidPooledStatement;
import com.google.common.base.Preconditions;
import com.oceanbase.jdbc.OceanBaseStatement;
import com.oceanbase.tools.loaddump.base.State;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.model.AdvancedOption;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.Summary;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.common.model.TaskDetail;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.concurrent.ExecutorTemplate;
import com.oceanbase.tools.loaddump.jdbc.JdbcExecutor;
import com.oceanbase.tools.loaddump.manager.SessionManager;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.Closeable;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectIntoOutfileClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(SelectIntoOutfileClient.class);
    private static final String GET_SECURE_FILE_DIR = "show variables like 'secure_file_priv'";
    private static final String REMOTE_DUMP_SQL = "select {0} * into outfile {1} FIELDS TERMINATED BY {2} OPTIONALLY ENCLOSED BY {3} LINES TERMINATED BY {4} from {5}";
    protected State state;
    protected final DumpParameter parameter;
    protected List<String> tables;
    protected boolean closed;
    protected ConnectionKey connectionKey;

    protected SelectIntoOutfileClient(DumpParameter parameter) {
        this.parameter = parameter;
        ThreadContext.put((String)"task.workspace", (String)parameter.getLogsPath());
    }

    public int dumpRecords() {
        boolean isFile;
        ConnectionKey connectionKey = this.parameter.getConnectionKey();
        SessionManager sessionManager = connectionKey.getSessionManager();
        String path = this.parameter.getFilePath();
        boolean bl = isFile = path.endsWith(".csv") || path.endsWith(".txt") || path.endsWith(".dat");
        if (isFile && this.tables.size() != 1) {
            throw new IllegalArgumentException("File name does not match the table count");
        }
        int parallel = this.parameter.getParallel();
        String parallelHint = parallel > 0 ? "/*+parallel(" + this.parameter.getParallel() + ")*/" : "";
        ExecutorTemplate<TaskDetail> template = new ExecutorTemplate<TaskDetail>("remote-dump-", this.parameter.getThreads());
        for (String table : this.tables) {
            String realFilePath = isFile ? path : FileUtils.toPath(path, table + ".csv");
            String sql = MessageFormat.format(REMOTE_DUMP_SQL, parallelHint, StringUtils.wrapWithQuot(realFilePath), StringUtils.wrapWithQuot(this.parameter.getColumnSeparator()), StringUtils.wrapWithQuot(this.parameter.getColumnDelimiter()), StringUtils.wrapWithQuot(StringEscapeUtils.escapeJava((String)this.parameter.getLineSeparator())), connectionKey.getServerMode().wrapName(table));
            template.submit(() -> {
                TaskDetail taskDetail = new TaskDetail();
                taskDetail.setSchema(connectionKey.getDatabase());
                taskDetail.setObject(table);
                taskDetail.setType(ObjectType.TABLE.getName());
                try (Connection conn = sessionManager.getPooledBizConnection();){
                    DruidPooledStatement stmt = (DruidPooledStatement)conn.createStatement();
                    OceanBaseStatement stmt1 = (OceanBaseStatement)stmt.getStatement();
                    log.info("Execute SQL: {}", (Object)sql);
                    long affected = stmt1.executeLargeUpdate(sql);
                    taskDetail.setCount(affected);
                    taskDetail.setState(TaskState.SUCCESS);
                }
                catch (Exception e) {
                    taskDetail.setState(TaskState.FAILURE);
                    taskDetail.setError(ExceptionUtils.getRootCauseMessage(e));
                    log.error("Dump [{}] failed!", (Object)table, (Object)e);
                }
                return taskDetail;
            });
        }
        List<TaskDetail> detailList = template.waitForResult();
        Summary summary = new Summary("All Remote Dump Tasks Finished", detailList);
        log.info(summary.toHumanReadableFormat());
        return detailList.stream().allMatch(TaskDetail::isSuccess) ? 0 : 1;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (this.connectionKey != null) {
            this.connectionKey.getSessionManager().destroy();
        }
        this.closed = true;
    }

    private void checkFilePath() {
        try {
            JdbcExecutor.query(this.parameter.getConnectionKey().getSessionManager().getPooledBizConnection(), GET_SECURE_FILE_DIR, rs -> {
                while (rs.next()) {
                    String secureDir = rs.getString(2);
                    if (secureDir.length() > 1 && secureDir.endsWith("/")) {
                        secureDir = secureDir.substring(0, secureDir.length() - 1);
                    }
                    Preconditions.checkArgument((boolean)StringUtils.startsWith((CharSequence)this.parameter.getFilePath(), (CharSequence)secureDir), (String)"Invalid value for `-f/--file-path`, which should under the path `%s`. See global system variable `secure_file_priv` for more information.", (Object)secureDir);
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private final DumpParameter parameter;

        public Builder(DumpParameter parameter) {
            this.parameter = parameter;
        }

        public SelectIntoOutfileClient build() throws Exception {
            SelectIntoOutfileClient target = new SelectIntoOutfileClient(this.parameter);
            Preconditions.checkArgument((this.parameter.getDataFormat() == DataFormat.CSV ? 1 : 0) != 0, (Object)"Remote dump only allows --csv");
            ConnectionKey connectionKey = this.parameter.buildConnectionKey();
            AdvancedOption advancedOption = new AdvancedOption(this.parameter, connectionKey.getServerMode());
            target.checkFilePath();
            target.tables = connectionKey.getMetadataProvider().queryTables(connectionKey, advancedOption).stream().map(TableInfo::getTable).collect(Collectors.toList());
            return target;
        }
    }
}

