/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.cmd;

import com.oceanbase.tools.loaddump.cmd.Connection;
import com.oceanbase.tools.loaddump.cmd.ObjectTypes;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import java.util.List;
import picocli.CommandLine;

public class Common {
    @CommandLine.ArgGroup(validate=false)
    private Base base;
    @CommandLine.ArgGroup(validate=false)
    private Connection connection;
    @CommandLine.ArgGroup(validate=false)
    private ObjectTypes objectTypes;
    @CommandLine.Option(names={"-V", "--version"}, versionHelp=true, description={"Display version info"})
    private boolean versionInfoRequested;
    @CommandLine.Option(names={"-H", "--help"}, usageHelp=true, description={"Display this help message"})
    private boolean usageHelpRequested;

    public Base getBase() {
        return this.base;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ObjectTypes getObjectTypes() {
        return this.objectTypes;
    }

    static class Base {
        @CommandLine.Option(names={"--ddl"}, description={"Interpret to load/dump the schema"})
        private boolean ddl;
        @CommandLine.Option(names={"--mix"}, description={"Interpret the mix data format"})
        private boolean mix;
        @CommandLine.Option(names={"--csv"}, description={"Interpret the csv data format"})
        private boolean csv;
        @CommandLine.Option(names={"--sql"}, description={"Interpret the sql data format"})
        private boolean sql;
        @CommandLine.Option(names={"--cut"}, description={"Interpret the cut data format"})
        private boolean cut;
        @CommandLine.Option(names={"--pos"}, description={"Interpret the pos data format"})
        private boolean pos;
        @CommandLine.Option(names={"--orc"}, description={"Interpret the orc data format"})
        private boolean orc;
        @CommandLine.Option(names={"--par"}, description={"Interpret the parquet data format"})
        private boolean par;
        @CommandLine.Option(names={"--ctl-path"}, description={"Interpret the path of control files"})
        private String ctlPath;
        @CommandLine.Option(names={"-f", "--file-path"}, description={"Interpret the path of the data files"})
        private String filePath;
        @CommandLine.Option(names={"--file-suffix"}, description={"Interpret the file suffix name"})
        private String fileSuffix;
        @CommandLine.Option(names={"--file-encoding"}, description={"Interpret the file encoding"})
        private String fileEncoding = "UTF-8";
        @CommandLine.Option(names={"--storage-uri"}, description={"Interpret the storage uri"})
        private String storageUri;
        @CommandLine.Option(names={"--public-cloud"}, description={"Interpret the env is public cloud"})
        private boolean publicCloud;
        @CommandLine.Option(names={"--no-sys"}, description={"Interpret the env is private cloud but without sys password"})
        private boolean noSys;
        @CommandLine.Option(names={"--server"}, description={"Interpret to use remote load/dump in the server"})
        private boolean useServer;
        @CommandLine.Option(names={"--logical-database"}, description={"Interpret the env is logical database"})
        private boolean logicalDatabase;
        @Deprecated
        @CommandLine.Option(names={"--nls-date-format"}, description={"Set nls_date_format='YYYY-MM-DD HH24:MI:SS'"})
        private String nlsDateFormat;
        @Deprecated
        @CommandLine.Option(names={"--nls-timestamp-format"}, description={"Set nls_timestamp_format='YYYY-MM-DD HH24:MI:SS:FF9'"})
        private String nlsTimestampFormat;
        @Deprecated
        @CommandLine.Option(names={"--nls-timestamp-tz-format"}, description={"Set nls_timestamp_tz_format='YYYY-MM-DD HH24:MI:SS.FF TZR TZD'"})
        private String nlsTimestampTzFormat;
        @CommandLine.Option(names={"--log-path"}, description={"Interpret the output path of log file"})
        private String logPath;
        @CommandLine.Option(names={"--column-splitter"}, description={"Interpret the split string for columns"})
        private String columnSplitter = String.valueOf('|');
        @CommandLine.Option(names={"--line-separator"}, description={"Interpret the char of line separator"})
        private String lineSeparator = System.lineSeparator();
        @CommandLine.Option(names={"--column-separator"}, description={"Interpret the char of column separator"})
        private String columnSeparator = ",";
        @CommandLine.Option(names={"--escape-character"}, description={"Interpret the char of the escape symbol"})
        private String escapeCharacter = "\\";
        @CommandLine.Option(names={"--column-delimiter"}, defaultValue="'", description={"Interpret the char of column delimiter"})
        private String columnDelimiter = "'";
        @CommandLine.Option(names={"--null-string"}, description={"Interpret the replace string of null"})
        private String nullString = "\\N";
        @CommandLine.Option(names={"--empty-string"}, description={"Interpret the replace string of empty"})
        private String emptyString = "\\E";
        @CommandLine.Option(names={"--with-trim"}, description={"Interpret to trim the blank char from tail"})
        private boolean withTrim;
        @CommandLine.Option(names={"--skip-header"}, description={"Interpret to skip the header of csv/cut data file"})
        private boolean skipHeader;
        @CommandLine.Option(names={"--trail-delimiter"}, description={"Interpret to trail the tail delimiter"})
        private boolean trailDelimiter;
        @CommandLine.Option(names={"--exclude-data-types"}, split=",", paramLabel="dataType", description={"Interpret to exclude the data types"})
        private List<String> excludeDataTypes;
        @CommandLine.Option(names={"--include-column-names"}, split=",", paramLabel="column", description={"Interpret to include the column names"})
        private List<String> includeColumnNames;
        @CommandLine.Option(names={"--exclude-column-names"}, split=",", paramLabel="column", description={"Interpret to exclude the column names"})
        private List<String> excludeColumnNames;
        @CommandLine.Option(names={"--thread"}, description={"Interpret the total count of worker threads"})
        private int thread = Constants.DEFAULT_IO_THREADS;
        @CommandLine.Option(names={"--parallel"}, description={"Interpret to parallel threads in the server. Specifically for direct load mode"})
        private int parallel = 1;
        @CommandLine.Option(names={"--retry"}, description={"Interpret to retry from the latest checkpoint"})
        private boolean retry;
        @CommandLine.Option(names={"--character-set"}, description={"Interpret the character set when connecting to the server"})
        private String characterSet;
        @CommandLine.Option(names={"--enable-hidden-pk"}, description={"Interpret whether to use the hidden primary key"})
        private boolean enableHiddenPk;
        @CommandLine.Option(names={"--session-config"}, description={"Interpret the connect configuration file path"})
        private String sessionConfig;

        Base() {
        }

        public boolean isDdl() {
            return this.ddl;
        }

        public boolean isMix() {
            return this.mix;
        }

        public boolean isCsv() {
            return this.csv;
        }

        public boolean isSql() {
            return this.sql;
        }

        public boolean isCut() {
            return this.cut;
        }

        public boolean isPos() {
            return this.pos;
        }

        public boolean isOrc() {
            return this.orc;
        }

        public boolean isPar() {
            return this.par;
        }

        public String getCtlPath() {
            return this.ctlPath;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public String getFileSuffix() {
            return this.fileSuffix;
        }

        public String getFileEncoding() {
            return this.fileEncoding;
        }

        public String getStorageUri() {
            return this.storageUri;
        }

        public boolean isPublicCloud() {
            return this.publicCloud;
        }

        public boolean isNoSys() {
            return this.noSys;
        }

        public boolean isUseServer() {
            return this.useServer;
        }

        public boolean isLogicalDatabase() {
            return this.logicalDatabase;
        }

        @Deprecated
        public String getNlsDateFormat() {
            return this.nlsDateFormat;
        }

        @Deprecated
        public String getNlsTimestampFormat() {
            return this.nlsTimestampFormat;
        }

        @Deprecated
        public String getNlsTimestampTzFormat() {
            return this.nlsTimestampTzFormat;
        }

        public String getLogPath() {
            return this.logPath;
        }

        public String getColumnSplitter() {
            return this.columnSplitter;
        }

        public String getLineSeparator() {
            return this.lineSeparator;
        }

        public String getColumnSeparator() {
            return this.columnSeparator;
        }

        public String getEscapeCharacter() {
            return this.escapeCharacter;
        }

        public String getColumnDelimiter() {
            return this.columnDelimiter;
        }

        public String getNullString() {
            return this.nullString;
        }

        public String getEmptyString() {
            return this.emptyString;
        }

        public boolean isWithTrim() {
            return this.withTrim;
        }

        public boolean isSkipHeader() {
            return this.skipHeader;
        }

        public boolean isTrailDelimiter() {
            return this.trailDelimiter;
        }

        public List<String> getExcludeDataTypes() {
            return this.excludeDataTypes;
        }

        public List<String> getIncludeColumnNames() {
            return this.includeColumnNames;
        }

        public List<String> getExcludeColumnNames() {
            return this.excludeColumnNames;
        }

        public int getThread() {
            return this.thread;
        }

        public int getParallel() {
            return this.parallel;
        }

        public boolean isRetry() {
            return this.retry;
        }

        public String getCharacterSet() {
            return this.characterSet;
        }

        public boolean isEnableHiddenPk() {
            return this.enableHiddenPk;
        }

        public String getSessionConfig() {
            return this.sessionConfig;
        }
    }
}

