/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.constants;

import com.google.common.collect.Sets;
import java.time.format.DateTimeFormatter;
import java.util.Set;

public class Constants {
    public static final int AVAILABLE_CPUS = Runtime.getRuntime().availableProcessors();
    public static final int ZERO_PART_LEVEL = 0;
    public static final int ONE_PART_LEVEL = 1;
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int GB = 0x40000000;
    public static final String MB_LITERAL = "MB";
    public static final String ROW_LITERAL = "ROW";
    public static final String WILDCARD = "*";
    public static final String NORMCARD = ".*";
    public static final String SEMICOLON = ";";
    public static final String DOUBLE_DOLLAR = "$$";
    public static final char RIGHT_BRACKETS = ')';
    public static final String DEFAULT_PLACE_HOLDER = "?";
    public static final String DOT = ".";
    public static final String DDL_SUFFIX = "-schema.sql";
    public static final String DATA_PREFIX = "data";
    public static final String LOG_PREFIX = "logs";
    public static final String FILE_PROTOCOL = "file://";
    public static String OCEANBASE_DRIVER_CLASS = "com.oceanbase.jdbc.Driver";
    public static final int MIN_PARALLEL = 3;
    public static final int MAX_PARALLEL_MACROS = 50;
    public static final String OBIDENTICAL = "_ob_identical_";
    public static final String DEFAULT_OBJECT_NAME = "CUSTOM_SQL";
    public static final String CREATE_TYPE_BODY_PREFIX = "create or replace type body";
    public static final int DEFAULT_IO_THREADS = Math.min(32, AVAILABLE_CPUS * 2);
    public static final int MAXIMUM_IO_THREADS = 32;
    public static final int DEFAULT_BUFFER_SIZE = 128;
    public static final int MAX_PROGRESS = 100;
    public static final int DEFAULT_SERVER_PARALLEL = 1;
    public static final int MINIMUM_PAGE_SIZE = 300000;
    public static final int DEFAULT_PAGE_SIZE = 1000000;
    public static final int MAXIMUM_PAGE_SIZE = 5000000;
    public static final int DEFAULT_COMMIT_SIZE = 2000;
    public static final int DEFAULT_MAX_ERRORS = 1000;
    public static final int DEFAULT_MAX_DISCARDS = 1000;
    public static final int DEFAULT_COMPACTION_TIMEOUT = 180;
    public static final String RUNNING = "RUNNING";
    public static final String SUCCESS = "SUCCESS";
    public static final String FAILURE = "FAILURE";
    public static final String TABLE = "table";
    public static final String OB_V4 = "4.0.0.0";
    public static final String OB_V2 = "2.0.0.0";
    public static final String OB_V2250 = "2.2.50";
    public static final String OB_V3230 = "3.2.3.0";
    public static final String OB_V2270 = "2.2.70";
    public static final String OB_V2230 = "2.2.3.0";
    public static final String OB_V1479 = "1.4.79";
    public static final String WEAK_READ = "WEAK";
    public static final String DEFAULT_QUERY_TIMEOUT_ONE = "1";
    public static final String DEFAULT_QUERY_TIMEOUT_THREE = "3";
    public static final String DEFAULT_QUERY_TIMEOUT_FIVE = "5";
    public static final String DEFAULT_QUERY_TIMEOUT_TWENTY_FOUR = "24";
    public static final String DEFAULT_SQL_MODE = "STRICT_ALL_TABLES,NO_ZERO_IN_DATE";
    public static final String DEFAULT_OB_PROXY_ROUTE_POLICY = "follower_first";
    public static final double DEFAULT_SLOW_THRESHOLD = 0.75;
    public static final double DEFAULT_PAUSE_THRESHOLD = 0.85;
    public static final String UNKNOWN_IP = "0.0.0.0";
    public static final long MAX_TRX_TIMEOUT = 9999999999L;
    public static final long MAX_QRY_TIMEOUT = 9999999999L;
    public static final int MAX_OPEN_CURSORS = 65535;
    public static final long MAX_ALLOWED_PACKET = 0x80000000L;
    public static final int MAX_MERGING_TIMEOUT = 10800000;
    public static final long DEFAULT_SPLITTER_SIZE = 0x4000000L;
    public static final long DEFAULT_ROLLOVER_SIZE = 0x40000000L;
    public static final double DEFAULT_READ_WRITE_RATIO = 1.0;
    public static final String SAFE = "SAFE";
    public static final String DEFAULT_FILE_ENCODING = "UTF-8";
    public static final String DEFAULT_CHARACTER_SET = "utf8";
    public static final String SYS_TENANT = "sys";
    public static final String OCEANBASE_DATABASE = "oceanbase";
    public static final String FILLER_RECOGNIZER = "_FILLER";
    public static final Set<String> HIDDEN_KEYS = Sets.newHashSet((Object[])new String[]{"__pk_increment", "__pk_cluster_id", "__pk_partition_id"});
    public static String DEFAULT_TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final DateTimeFormatter DEFAULT_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern(DEFAULT_TIMESTAMP_PATTERN);
    public static String DEFAULT_TIMESTAMP_TZ_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final DateTimeFormatter DEFAULT_TIMESTAMP_TZ_FORMATTER = DateTimeFormatter.ofPattern(DEFAULT_TIMESTAMP_TZ_PATTERN);
    public static String DEFAULT_TIMESTAMP_LTZ_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final DateTimeFormatter DEFAULT_TIMESTAMP_LTZ_FORMATTER = DateTimeFormatter.ofPattern(DEFAULT_TIMESTAMP_LTZ_PATTERN);
    public static String DEFAULT_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final DateTimeFormatter DEFAULT_DATETIME_FORMATTER = DateTimeFormatter.ofPattern(DEFAULT_DATETIME_PATTERN);
    public static String DEFAULT_TIME_PATTERN = "HH:mm:ss";
    public static final DateTimeFormatter DEFAULT_TIME_FORMATTER = DateTimeFormatter.ofPattern(DEFAULT_TIME_PATTERN);
    public static String DEFAULT_MYSQL_DATE_PATTERN = "yyyy-MM-dd";
    public static final DateTimeFormatter DEFAULT_MYSQL_DATE_FORMATTER = DateTimeFormatter.ofPattern(DEFAULT_MYSQL_DATE_PATTERN);
    public static String DEFAULT_ORACLE_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final DateTimeFormatter DEFAULT_ORACLE_DATE_FORMATTER = DateTimeFormatter.ofPattern(DEFAULT_ORACLE_DATE_PATTERN);
    public static final String DEFAULT_NLS_DATE_FORMAT = "YYYY-MM-DD HH24:MI:SS";
    public static final String DEFAULT_NLS_TIMESTAMP_FORMAT = "YYYY-MM-DD HH24:MI:SS:FF9";
    public static final String DEFAULT_NLS_TIMESTAMP_TZ_FORMAT = "YYYY-MM-DD HH24:MI:SS:FF TZR TZD";
    public static String NO_SUBFILES = "No subfiles";
    public static String FILE_NOT_FOUND = "files are not found in the path";
    public static final String HIDDEN_PRIMARY_KEY = "__pk_increment";
    public static final String HIDDEN_COLUMN_VISIBLE = "'hidden_column_visible', 'true'";
    public static final String MYSQL_DRC_USER = "__oceanbase_inner_drc_user";
    public static final String ORACLE_DRC_USER = "__OCEANBASE_INNER_DRC_USER";

    public static interface S3AFsConsts {
        public static final String ENDPOINT_REGION_KEY = "fs.s3a.endpoint.region";
        public static final String ACCESS_KEY_ID = "fs.s3a.access.key";
        public static final String SECRET_KEY_ID = "fs.s3a.secret.key";
        public static final String IMPL_CLASS_KEY = "fs.s3a.impl";
        public static final String IMPL_CLASS = "org.apache.hadoop.fs.s3a.S3AFileSystem";
    }

    public static interface OssFsConsts {
        public static final String ENDPOINT_KEY = "fs.oss.endpoint";
        public static final String ACCESS_KEY_ID = "fs.oss.accessKeyId";
        public static final String SECRET_KEY_ID = "fs.oss.accessKeySecret";
        public static final String IMPL_CLASS_KEY = "fs.oss.impl";
        public static final String IMPL_CLASS = "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem";
    }

    public static interface ErrConsts {
        public static final String NOT_EXISTS_MYSQL = "doesn't exist";
        public static final String NOT_EXISTS_ORACLE = "does not exist";
        public static final String UNIQUE_CONSTRAINT = "unique constraint";
        public static final String DUPLICATE_ENTRY = "Duplicate entry";
        public static final String OBSERVER_TIMEOUT = "-4012, Timeout";
        public static final String OPERATION_TIMEOUT = "Operation timed out";
        public static final String TRX_IS_KILLED = "Transaction is killed";
        public static final String TRX_ROLLBACKED = "Transaction rollbacked";
        public static final String CONNECTION_RESET = "Connection reset";
        public static final String NETWORK_IS_UNREACHABLE = "Network is unreachable";
        public static final String CONNECT_TIMEOUT = "Connect timed out";
        public static final String READ_TIMEOUT = "Read timed out";
        public static final String RPC_SEND_ERROR = "RPC send error";
        public static final String CONNECTION_REFUSED = "Connection refused";
        public static final String SERVER_CLOSED_ERROR = "unexpected end of stream";
        public static final String CANT_READ_RESPONSE = "Can not read response from server";
        public static final String TRX_EXITING = "Transaction exiting";
        public static final String TRX_NEED_ROLLBACK = "transaction need rollback";
        public static final String TRX_NEEDS_ROLLBACK = "transaction needs rollback";
        public static final String TRX_CTX_NOT_EXIST = "Transaction context does not exist";
        public static final String TENANT_MEMORY_LIMIT = "No memory or reach tenant memory limit";
        public static final String INCORRECT_INTEGER_VALUE = "Incorrect integer value";
        public static final String INCORRECT_STRING_VALUE = "Incorrect string value";
        public static final String INCORRECT_VALUE = "Incorrect value";
        public static final String INVALID_NUMBER = "invalid number";
        public static final String INVALID_MONTH = "not a valid month";
        public static final String INVALID_HEX_NUMBER = "invalid hex number";
        public static final String DATA_TOO_LONG = "Data too long for column";
        public static final String VALUE_TOO_LARGE = "value too large for column";
        public static final String OUT_OF_RANGE = "Out of range value for column";
        public static final String COLUMN_COUNT_MISMATCH_AT_PARSE = "The number of columns parsed does not match the number of columns in the table";
        public static final String COLUMN_COUNT_MISMATCH = "Column count doesn't match value count";
        public static final String VALUE_IS_LARGER = "value larger than specified precision allowed for this column";
        public static final String NON_NUMERIC_CHARACTER = "a non-numeric character was found where a numeric was expected";
        public static final String INCONSISTENT_DATATYPES = "inconsistent datatypes";
        public static final String NO_PARTITION_FOR_VALUE = "Table has no partition for value";
        public static final String NOT_MAP_TO_ANY_PARTITION = "inserted partition key does not map to any partition";
        public static final String BAD_DATE_FORMAT = "date format picture ends before converting entire input string";
        public static final String NOT_NULL_VIOLATION_MYSQL = "cannot be null";
        public static final String NOT_NULL_VIOLATION_ORACLE = "cannot insert NULL into";
        public static final String DATA_TRUNCATED_FOR_ARGUMENT = "Data truncated for argument";
    }

    public static interface CsvConsts {
        public static final char RS = '\u001e';
        public static final char SP = ' ';
        public static final char TAB = '\t';
        public static final char COMMA = ',';
        public static final char PIPE = '|';
        public static final String EMPTY = "";
        public static final char BACKSLASH = '\\';
        public static final char BACKSPACE = '\b';
        public static final String NULL_STRING = "\\N";
        public static final String EMPTY_STRING = "\\E";
        public static final char COMMENT = '#';
        public static final char CR = '\r';
        public static final char LF = '\n';
        public static final char FF = '\f';
        public static final String CRLF = "\r\n";
        public static final Character SINGLE_QUOTE_CHAR = Character.valueOf('\'');
        public static final Character DOUBLE_QUOTE_CHAR = Character.valueOf('\"');
        public static final int END_OF_STREAM = -1;
        public static final String LINE_SEPARATOR = "\u2028";
        public static final String NEXT_LINE = "\u0085";
        public static final String PARAGRAPH_SEPARATOR = "\u2029";
        public static final int UNDEFINED = -2;
        public static final char US = '\u001f';
        public static final byte[] ASCII_NILL = new byte[]{0};
        public static final String DEFAULT_CHARSET = "UTF-8";
        public static final String ASCII_NULL_STRING = new String(ASCII_NILL);
        public static final int ASCII_NULL_LENGTH = ASCII_NULL_STRING.length();
    }

    public static interface MemConsts {
        public static final long _1GB = 0x40000000L;
        public static final long _4GB = 0x100000000L;
        public static final long _8GB = 0x200000000L;
        public static final long _16GB = 0x400000000L;
    }

    public static interface Arabic {
        public static final int ZERO = 0;
        public static final int ONE = 1;
        public static final int TWO = 2;
        public static final int THREE = 3;
        public static final int FOUR = 4;
    }

    public static interface CbsConsts {
        public static final String DATABASE = "database.json";
    }

    public static interface CheckPoint {
        public static final String DUMP_CHECKPOINT_FILE = ".dump.ckpt";
        public static final String LOAD_CHECKPOINT_FILE = ".load.ckpt";
    }
}

