/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.Database;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.MapObject;
import com.oceanbase.tools.loaddump.common.model.SessionConfig;
import com.oceanbase.tools.loaddump.common.model.storage.BaseStorageConfig;
import com.oceanbase.tools.loaddump.manager.ControlManager;
import com.oceanbase.tools.loaddump.parser.record.csv.CsvFormat;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;

public abstract class BaseParameter {
    private final Set<String> excludeDataTypes = Sets.newHashSet();
    private final Set<String> excludeColumnNames = Sets.newHashSet();
    private final LinkedHashSet<String> includeColumnNames = Sets.newLinkedHashSet();
    private final Map<ObjectType, Set<String>> blackListMap = new HashMap<ObjectType, Set<String>>();
    private final Map<ObjectType, Set<String>> whiteListMap = new HashMap<ObjectType, Set<String>>();
    private final Map<String, Map<String, MapObject>> columnNameMapping = new HashMap<String, Map<String, MapObject>>();
    private boolean pubCloud;
    private boolean noSys;
    private boolean useServer;
    private boolean logicalDatabase = false;
    private String host;
    private String port;
    private String cluster;
    private String tenant;
    private String user;
    private String password;
    private String databaseName;
    private String connectDatabaseName;
    private String sysUser = "root";
    private String sysPassword;
    private boolean useServerPrepStmts = true;
    private String filePath;
    private BaseStorageConfig storageConfig;
    private String ctlPath;
    private String columnSplitter;
    private boolean includeDdl;
    private DataFormat dataFormat;
    @Deprecated
    private String nlsDateFormat = "YYYY-MM-DD HH24:MI:SS";
    @Deprecated
    private String nlsTimestampFormat = "YYYY-MM-DD HH24:MI:SS:FF9";
    @Deprecated
    private String nlsTimestampTzFormat = "YYYY-MM-DD HH24:MI:SS:FF TZR TZD";
    private String socksProxyHost;
    private String socksProxyPort;
    private String logPath;
    private Character escapeCharacter = Character.valueOf('\\');
    private Character columnDelimiter = Character.valueOf('\'');
    private Character columnSeparator = Character.valueOf(',');
    private String lineSeparator = "\n";
    private String nullString = "\\N";
    private String emptyString = "\\E";
    private String emptyReplacer = null;
    private boolean skipHeader = false;
    private boolean skipFooter = false;
    private boolean withTrim = false;
    private boolean trailingDelimiter = false;
    private boolean ignoreEmptyLine = true;
    private int threads = Constants.DEFAULT_IO_THREADS;
    private int parallel = 1;
    private String fileSuffix;
    private String fileEncoding = "UTF-8";
    private long blockSize = 0x4000000L;
    private boolean retry;
    private boolean enableHiddenPk;
    private SessionConfig sessionConfig;
    private transient Database database;
    private transient ConnectionKey connectionKey;
    private transient ControlManager controlManager;
    private transient Map<String, CsvFormat> formatMap;
    protected Map<String, String> sourceTargetTableMap;

    public BaseParameter() {
        this.lineSeparator = System.getProperty("line.separator");
    }

    public String getRootPath() {
        return this.filePath;
    }

    public String getDataPath() {
        return FileUtils.toPath(this.filePath, "data");
    }

    public String getLogsPath() {
        if (StringUtils.isBlank(this.logPath)) {
            return FileUtils.toPath(this.filePath, "logs");
        }
        return FileUtils.toPath(this.logPath);
    }

    public String getDefaultDatabasePath() {
        Preconditions.checkArgument((this.databaseName != null ? 1 : 0) != 0, (Object)"database name has not been set yet");
        return FileUtils.toPath(this.getDataPath(), this.databaseName) + File.separator;
    }

    public String getDefaultTableDataPath() {
        Preconditions.checkArgument((this.databaseName != null ? 1 : 0) != 0, (Object)"database name has not been set yet");
        return FileUtils.toPath(this.getDataPath(), this.databaseName, ObjectType.TABLE.getName()) + File.separator;
    }

    public boolean isSplitable() {
        return this.getBlockSize() > 0L;
    }

    public boolean hasNoSysPrivileges() {
        return this.connectionKey.hasNoSysPrivileges();
    }

    public synchronized ConnectionKey buildConnectionKey() {
        if (this.connectionKey == null) {
            this.connectionKey = new ConnectionKey.Builder().host(this.host).port(this.port).cluster(this.cluster).tenant(this.tenant).username(this.user).password(this.password).database(this.databaseName).connectDatabase(this.connectDatabaseName).pubCloud(this.pubCloud).noSys(this.noSys).sysUser(this.sysUser).sysPassword(this.sysPassword).concurrency(this.threads).sessionConfig(this.sessionConfig).build();
        }
        return this.connectionKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, CsvFormat> initCsvFormatMap() {
        if (MapUtils.isNotEmpty(this.formatMap)) {
            return this.formatMap;
        }
        Class<BaseParameter> clazz = BaseParameter.class;
        synchronized (BaseParameter.class) {
            this.formatMap = new HashMap<String, CsvFormat>(16);
            CsvFormat format = CsvFormat.MYSQL.withDelimiter(',');
            format = format.withTrim(this.isWithTrim());
            format = format.withIgnoreEmptyLines(true);
            format = format.withIgnoreSurroundingSpaces(true);
            format = format.withSkipHeaderRecord(this.isSkipHeader());
            if (this instanceof LoadParameter) {
                format = format.withSkipFooterRecord(this.isSkipFooter());
            }
            format = format.withTrailingDelimiter(this.isTrailingDelimiter());
            format = format.withQuote(this.getColumnDelimiter());
            format = format.withNullString(this.getNullString());
            format = format.withEmptyString(this.getEmptyString());
            format = format.withEmptyReplacer(this.getEmptyReplacer());
            String escape = String.valueOf(this.getEscapeCharacter());
            format = format.withEscape(format.toChar(escape));
            String delimiter = String.valueOf(this.getColumnSeparator());
            format = format.withDelimiter(format.toChar(delimiter));
            format = format.withRecordSeparator(this.getLineSeparator());
            for (String tableName : this.getDatabase().getTableNames()) {
                this.formatMap.put(tableName, format.withHeader(this.getDatabase().getTableInfo(tableName).getCsvHeaders()));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.formatMap;
        }
    }

    public Set<String> getExcludeDataTypes() {
        return this.excludeDataTypes;
    }

    public Set<String> getExcludeColumnNames() {
        return this.excludeColumnNames;
    }

    public LinkedHashSet<String> getIncludeColumnNames() {
        return this.includeColumnNames;
    }

    public Map<ObjectType, Set<String>> getBlackListMap() {
        return this.blackListMap;
    }

    public Map<ObjectType, Set<String>> getWhiteListMap() {
        return this.whiteListMap;
    }

    public Map<String, Map<String, MapObject>> getColumnNameMapping() {
        return this.columnNameMapping;
    }

    public boolean isPubCloud() {
        return this.pubCloud;
    }

    public void setPubCloud(boolean pubCloud) {
        this.pubCloud = pubCloud;
    }

    public boolean isNoSys() {
        return this.noSys;
    }

    public void setNoSys(boolean noSys) {
        this.noSys = noSys;
    }

    public boolean isUseServer() {
        return this.useServer;
    }

    public void setUseServer(boolean useServer) {
        this.useServer = useServer;
    }

    public boolean isLogicalDatabase() {
        return this.logicalDatabase;
    }

    public void setLogicalDatabase(boolean logicalDatabase) {
        this.logicalDatabase = logicalDatabase;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getConnectDatabaseName() {
        return this.connectDatabaseName;
    }

    public void setConnectDatabaseName(String connectDatabaseName) {
        this.connectDatabaseName = connectDatabaseName;
    }

    public String getSysUser() {
        return this.sysUser;
    }

    public void setSysUser(String sysUser) {
        this.sysUser = sysUser;
    }

    public String getSysPassword() {
        return this.sysPassword;
    }

    public void setSysPassword(String sysPassword) {
        this.sysPassword = sysPassword;
    }

    public boolean isUseServerPrepStmts() {
        return this.useServerPrepStmts;
    }

    public void setUseServerPrepStmts(boolean useServerPrepStmts) {
        this.useServerPrepStmts = useServerPrepStmts;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public BaseStorageConfig getStorageConfig() {
        return this.storageConfig;
    }

    public void setStorageConfig(BaseStorageConfig storageConfig) {
        this.storageConfig = storageConfig;
    }

    public String getCtlPath() {
        return this.ctlPath;
    }

    public void setCtlPath(String ctlPath) {
        this.ctlPath = ctlPath;
    }

    public String getColumnSplitter() {
        return this.columnSplitter;
    }

    public void setColumnSplitter(String columnSplitter) {
        this.columnSplitter = columnSplitter;
    }

    public boolean isIncludeDdl() {
        return this.includeDdl;
    }

    public void setIncludeDdl(boolean includeDdl) {
        this.includeDdl = includeDdl;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    @Deprecated
    public String getNlsDateFormat() {
        return this.nlsDateFormat;
    }

    @Deprecated
    public void setNlsDateFormat(String nlsDateFormat) {
        this.nlsDateFormat = nlsDateFormat;
    }

    @Deprecated
    public String getNlsTimestampFormat() {
        return this.nlsTimestampFormat;
    }

    @Deprecated
    public void setNlsTimestampFormat(String nlsTimestampFormat) {
        this.nlsTimestampFormat = nlsTimestampFormat;
    }

    @Deprecated
    public String getNlsTimestampTzFormat() {
        return this.nlsTimestampTzFormat;
    }

    @Deprecated
    public void setNlsTimestampTzFormat(String nlsTimestampTzFormat) {
        this.nlsTimestampTzFormat = nlsTimestampTzFormat;
    }

    public String getSocksProxyHost() {
        return this.socksProxyHost;
    }

    public void setSocksProxyHost(String socksProxyHost) {
        this.socksProxyHost = socksProxyHost;
    }

    public String getSocksProxyPort() {
        return this.socksProxyPort;
    }

    public void setSocksProxyPort(String socksProxyPort) {
        this.socksProxyPort = socksProxyPort;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public Character getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public void setEscapeCharacter(Character escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    public Character getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public void setColumnDelimiter(Character columnDelimiter) {
        this.columnDelimiter = columnDelimiter;
    }

    public Character getColumnSeparator() {
        return this.columnSeparator;
    }

    public void setColumnSeparator(Character columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    public String getEmptyString() {
        return this.emptyString;
    }

    public void setEmptyString(String emptyString) {
        this.emptyString = emptyString;
    }

    public String getEmptyReplacer() {
        return this.emptyReplacer;
    }

    public void setEmptyReplacer(String emptyReplacer) {
        this.emptyReplacer = emptyReplacer;
    }

    public boolean isSkipHeader() {
        return this.skipHeader;
    }

    public void setSkipHeader(boolean skipHeader) {
        this.skipHeader = skipHeader;
    }

    public boolean isSkipFooter() {
        return this.skipFooter;
    }

    public void setSkipFooter(boolean skipFooter) {
        this.skipFooter = skipFooter;
    }

    public boolean isWithTrim() {
        return this.withTrim;
    }

    public void setWithTrim(boolean withTrim) {
        this.withTrim = withTrim;
    }

    public boolean isTrailingDelimiter() {
        return this.trailingDelimiter;
    }

    public void setTrailingDelimiter(boolean trailingDelimiter) {
        this.trailingDelimiter = trailingDelimiter;
    }

    public boolean isIgnoreEmptyLine() {
        return this.ignoreEmptyLine;
    }

    public void setIgnoreEmptyLine(boolean ignoreEmptyLine) {
        this.ignoreEmptyLine = ignoreEmptyLine;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public int getParallel() {
        return this.parallel;
    }

    public void setParallel(int parallel) {
        this.parallel = parallel;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    public boolean isRetry() {
        return this.retry;
    }

    public void setRetry(boolean retry) {
        this.retry = retry;
    }

    public boolean isEnableHiddenPk() {
        return this.enableHiddenPk;
    }

    public void setEnableHiddenPk(boolean enableHiddenPk) {
        this.enableHiddenPk = enableHiddenPk;
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public void setSessionConfig(SessionConfig sessionConfig) {
        this.sessionConfig = sessionConfig;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public void setConnectionKey(ConnectionKey connectionKey) {
        this.connectionKey = connectionKey;
    }

    public ConnectionKey getConnectionKey() {
        return this.connectionKey;
    }

    public void setControlManager(ControlManager controlManager) {
        this.controlManager = controlManager;
    }

    public ControlManager getControlManager() {
        return this.controlManager;
    }

    public void setFormatMap(Map<String, CsvFormat> formatMap) {
        this.formatMap = formatMap;
    }

    public Map<String, CsvFormat> getFormatMap() {
        return this.formatMap;
    }

    public Map<String, String> getSourceTargetTableMap() {
        return this.sourceTargetTableMap;
    }

    public void setSourceTargetTableMap(Map<String, String> sourceTargetTableMap) {
        this.sourceTargetTableMap = sourceTargetTableMap;
    }
}

