/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.google.common.base.Preconditions;
import com.oceanbase.partition.calculator.ObPartIdCalculator;
import com.oceanbase.partition.calculator.enums.ObServerMode;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.partition.calculator.model.TableEntryKey;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.metadata.MetadataProvider;
import com.oceanbase.tools.loaddump.common.metadata.MetadataProviderV3;
import com.oceanbase.tools.loaddump.common.metadata.MetadataProviderV4;
import com.oceanbase.tools.loaddump.common.model.SessionConfig;
import com.oceanbase.tools.loaddump.manager.SessionManager;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionKey
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ConnectionKey.class);
    public static final String ROOT_USER = "root";
    public static final String PROXYRO_USER = "proxyro";
    private static final long serialVersionUID = -3156696875930969151L;
    private String jdbcProtocol = "jdbc:oceanbase://";
    private SessionConfig sessionConfig;
    private boolean publicCloud;
    private boolean noSys;
    private String[] host;
    private String[] port;
    private String cluster;
    private String tenant;
    private String username;
    private String password;
    private String database;
    private String connectDatabase;
    private transient String driverClassName;
    private String sysUser;
    private String sysPassword;
    private boolean useTraceLog = true;
    private transient MetadataProvider metadataProvider;
    private transient SessionManager sessionManager;
    private ServerMode serverMode;
    private int concurrency;

    private ConnectionKey() {
    }

    public boolean hasNoSysPrivileges() {
        return this.publicCloud || this.noSys;
    }

    public String getJdbcUrl4Sys() {
        return this.jdbcProtocol + this.buildHostPortString() + "/" + "oceanbase" + this.sessionConfig.getJdbcUrlOptionsString();
    }

    public String getJdbcUrl4Biz() {
        return this.jdbcProtocol + this.buildHostPortString() + "/" + this.database + this.sessionConfig.getJdbcUrlOptionsString();
    }

    private String buildHostPortString() {
        StringBuilder sb = new StringBuilder();
        int size = Math.min(this.host.length, this.port.length);
        String defaultPort = this.port[0];
        for (int i = 0; i < this.host.length; ++i) {
            sb.append(this.host[i]).append(":").append(i < size ? this.port[i] : defaultPort);
            if (i >= this.host.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    @NonNull
    public List<String> getInitSql4Biz() {
        return this.serverMode.isMysqlMode() ? this.sessionConfig.getInitSql4Mysql() : this.sessionConfig.getInitSql4Oracle();
    }

    @NonNull
    public List<String> getInitSql4Sys() {
        return this.sessionConfig.getInitSql4Mysql();
    }

    public String getDefaultUser() {
        return this.buildUser(this.getUsername(), this.getTenant());
    }

    public String getSysTenantUser() {
        return this.buildUser(this.getSysUser(), "sys");
    }

    private String buildUser(String user, String tenant) {
        String cluster;
        if (this.isPublicCloud()) {
            return user;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(user);
        if (StringUtils.isNotBlank(tenant)) {
            sb.append("@").append(tenant);
        }
        if (StringUtils.isNotBlank(cluster = this.getCluster())) {
            sb.append("#").append(cluster);
        }
        return sb.toString();
    }

    public TableEntryKey createTableEntryKey(String table) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(table), (Object)"Input table is null");
        ObServerMode mode = ObServerMode.from((String)this.serverMode.name(), (String)this.serverMode.getVersion());
        return new TableEntryKey(this.cluster, this.tenant, this.database, table, mode);
    }

    public ObPartIdCalculator createPartitionIdCalculator(TableEntry tableEntry, boolean subsequentV4) {
        return new ObPartIdCalculator(this.hasNoSysPrivileges() && this.serverMode.isPreviousV4(), tableEntry, subsequentV4);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("ConnectionKey [ host: ").append(Arrays.toString(this.host));
        sb.append(", port: ").append(Arrays.toString(this.port));
        sb.append(", tenant: ").append(this.tenant);
        sb.append(", cluster: ").append(this.cluster);
        sb.append(", username: ").append(this.username);
        sb.append(", password: ******");
        sb.append(", database: ").append(this.database);
        sb.append(", connectDatabase: ").append(this.connectDatabase);
        sb.append(", sysUser: ").append(this.sysUser);
        sb.append(", sysPassword: ******");
        sb.append(", log: ").append(this.useTraceLog);
        sb.append(", sessionConfig").append(this.sessionConfig);
        return sb.append(" ]").toString();
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public boolean isPublicCloud() {
        return this.publicCloud;
    }

    public void setPublicCloud(boolean publicCloud) {
        this.publicCloud = publicCloud;
    }

    public boolean isNoSys() {
        return this.noSys;
    }

    public void setNoSys(boolean noSys) {
        this.noSys = noSys;
    }

    public String[] getHost() {
        return this.host;
    }

    public void setHost(String[] host) {
        this.host = host;
    }

    public String[] getPort() {
        return this.port;
    }

    public void setPort(String[] port) {
        this.port = port;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getConnectDatabase() {
        return this.connectDatabase;
    }

    public void setConnectDatabase(String connectDatabase) {
        this.connectDatabase = connectDatabase;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getSysUser() {
        return this.sysUser;
    }

    public void setSysUser(String sysUser) {
        this.sysUser = sysUser;
    }

    public String getSysPassword() {
        return this.sysPassword;
    }

    public void setSysPassword(String sysPassword) {
        this.sysPassword = sysPassword;
    }

    public boolean isUseTraceLog() {
        return this.useTraceLog;
    }

    public void setUseTraceLog(boolean useTraceLog) {
        this.useTraceLog = useTraceLog;
    }

    public MetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public ServerMode getServerMode() {
        return this.serverMode;
    }

    public void setServerMode(ServerMode serverMode) {
        this.serverMode = serverMode;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    static /* synthetic */ String[] access$102(ConnectionKey x0, String[] x1) {
        x0.host = x1;
        return x1;
    }

    static /* synthetic */ String[] access$202(ConnectionKey x0, String[] x1) {
        x0.port = x1;
        return x1;
    }

    public static class Builder {
        private ConnectionKey target = new ConnectionKey();

        public Builder host(String host) {
            ConnectionKey.access$102(this.target, StringUtils.split((String)host, (char)','));
            return this;
        }

        public Builder port(String port) {
            ConnectionKey.access$202(this.target, StringUtils.split((String)port, (char)','));
            return this;
        }

        public Builder cluster(String clusterName) {
            this.target.cluster = clusterName;
            return this;
        }

        public Builder tenant(String tenant) {
            this.target.tenant = tenant;
            return this;
        }

        public Builder username(String username) {
            this.target.username = username;
            return this;
        }

        public Builder password(String password) {
            this.target.password = password;
            return this;
        }

        public Builder database(String database) {
            this.target.database = database;
            return this;
        }

        public Builder connectDatabase(String connectDatabase) {
            this.target.connectDatabase = connectDatabase;
            return this;
        }

        public Builder pubCloud(boolean pubCloud) {
            this.target.publicCloud = pubCloud;
            return this;
        }

        public Builder noSys(boolean noSys) {
            this.target.noSys = noSys;
            return this;
        }

        public Builder sysUser(String sysUser) {
            this.target.sysUser = sysUser;
            return this;
        }

        public Builder sysPassword(String sysPassword) {
            this.target.sysPassword = sysPassword;
            return this;
        }

        public Builder log(boolean log) {
            this.target.useTraceLog = log;
            return this;
        }

        public Builder concurrency(int threads) {
            this.target.concurrency = threads;
            return this;
        }

        public Builder sessionConfig(SessionConfig config) {
            this.target.sessionConfig = config;
            return this;
        }

        public ConnectionKey build() {
            if (this.target.port.length != 1 && this.target.port.length != this.target.host.length) {
                throw new IllegalArgumentException("Unmatched hosts and ports");
            }
            String jdbcHamode = this.target.sessionConfig.getJdbcHamode();
            if (StringUtils.isNotEmpty(jdbcHamode)) {
                this.target.jdbcProtocol = "jdbc:oceanbase:" + jdbcHamode + "://";
            }
            try {
                Class.forName(Constants.OCEANBASE_DRIVER_CLASS);
                this.target.driverClassName = Constants.OCEANBASE_DRIVER_CLASS;
                this.target.sessionManager = new SessionManager().init(this.target);
                log.info("Server Mode: {}", (Object)this.target.serverMode.toString());
                this.target.metadataProvider = this.target.serverMode.isPreviousV4() ? new MetadataProviderV3(this.target.sessionManager) : new MetadataProviderV4(this.target.sessionManager);
                return this.target;
            }
            catch (ClassNotFoundException e) {
                log.error("OceanBase Connector/J jar is not found in class path, you may check the integrity of this software");
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

