/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.UploadBehavior;
import com.oceanbase.tools.loaddump.common.model.BaseParameter;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class DumpParameter
extends BaseParameter {
    private final Set<Integer> includeColumnIndex = new HashSet<Integer>();
    private Long maxRows;
    private String querySql;
    private String outputFile;
    private boolean noNestedDir;
    private String whereClause;
    private String flashbackScn;
    private Set<String> partitions;
    private String flashbackTimestamp;
    private boolean distinct = false;
    private boolean snapshot = true;
    private boolean weakRead = false;
    private boolean skipCheckDir = false;
    private boolean removeNewline = false;
    private boolean retainEmptyFiles = false;
    private boolean excludeVirtualColumns = false;
    private int parallelMacros = 8;
    private int pageSize = 1000000;
    private int commitSize = 2000;
    private long maxFileSize = -1048576L;
    private boolean schemaless = true;
    private boolean withExtra = false;
    private boolean droppable = false;
    private boolean useRuntimeTableName = false;
    private String blockSizeUnit = "MB";
    private String timeValuePattern = "";
    private String datetimeValuePattern = "";
    private String timestampTzValuePattern = "";
    private String timestampLtzValuePattern = "";
    private String dateValuePattern = "";
    private String timestampValuePattern = "";
    private UploadBehavior uploadBehavior;
    private int fetchSize;
    private boolean preserveZeroDatetime;
    private boolean compactSchema;
    private String ckptPath;

    public String getCheckpointPath() {
        if (this.ckptPath != null) {
            return this.ckptPath;
        }
        this.ckptPath = FileUtils.toPath(this.getFilePath(), ".dump.ckpt");
        return this.ckptPath;
    }

    @Override
    public String getDefaultDatabasePath() {
        Preconditions.checkArgument((super.getDatabaseName() != null ? 1 : 0) != 0, (Object)"database name has not been set yet");
        if (this.noNestedDir || StringUtils.isNotEmpty(this.outputFile)) {
            return this.getFilePath();
        }
        return FileUtils.toPath(this.getDataPath(), super.getDatabaseName()) + File.separator;
    }

    @Override
    public String getDefaultTableDataPath() {
        Preconditions.checkArgument((super.getDatabaseName() != null ? 1 : 0) != 0, (Object)"database name has not been set yet");
        if (this.noNestedDir || StringUtils.isNotEmpty(this.outputFile)) {
            return this.getFilePath();
        }
        return FileUtils.toPath(this.getDataPath(), super.getDatabaseName(), ObjectType.TABLE.getName()) + File.separator;
    }

    public Set<Integer> getIncludeColumnIndex() {
        return this.includeColumnIndex;
    }

    public Long getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(Long maxRows) {
        this.maxRows = maxRows;
    }

    public String getQuerySql() {
        return this.querySql;
    }

    public void setQuerySql(String querySql) {
        this.querySql = querySql;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public boolean isNoNestedDir() {
        return this.noNestedDir;
    }

    public void setNoNestedDir(boolean noNestedDir) {
        this.noNestedDir = noNestedDir;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    public String getFlashbackScn() {
        return this.flashbackScn;
    }

    public void setFlashbackScn(String flashbackScn) {
        this.flashbackScn = flashbackScn;
    }

    public Set<String> getPartitions() {
        return this.partitions;
    }

    public void setPartitions(Set<String> partitions) {
        this.partitions = partitions;
    }

    public String getFlashbackTimestamp() {
        return this.flashbackTimestamp;
    }

    public void setFlashbackTimestamp(String flashbackTimestamp) {
        this.flashbackTimestamp = flashbackTimestamp;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    public boolean isWeakRead() {
        return this.weakRead;
    }

    public void setWeakRead(boolean weakRead) {
        this.weakRead = weakRead;
    }

    public boolean isSkipCheckDir() {
        return this.skipCheckDir;
    }

    public void setSkipCheckDir(boolean skipCheckDir) {
        this.skipCheckDir = skipCheckDir;
    }

    public boolean isRemoveNewline() {
        return this.removeNewline;
    }

    public void setRemoveNewline(boolean removeNewline) {
        this.removeNewline = removeNewline;
    }

    public boolean isRetainEmptyFiles() {
        return this.retainEmptyFiles;
    }

    public void setRetainEmptyFiles(boolean retainEmptyFiles) {
        this.retainEmptyFiles = retainEmptyFiles;
    }

    public boolean isExcludeVirtualColumns() {
        return this.excludeVirtualColumns;
    }

    public void setExcludeVirtualColumns(boolean excludeVirtualColumns) {
        this.excludeVirtualColumns = excludeVirtualColumns;
    }

    public int getParallelMacros() {
        return this.parallelMacros;
    }

    public void setParallelMacros(int parallelMacros) {
        this.parallelMacros = parallelMacros;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public boolean isSchemaless() {
        return this.schemaless;
    }

    public void setSchemaless(boolean schemaless) {
        this.schemaless = schemaless;
    }

    public boolean isWithExtra() {
        return this.withExtra;
    }

    public void setWithExtra(boolean withExtra) {
        this.withExtra = withExtra;
    }

    public boolean isDroppable() {
        return this.droppable;
    }

    public void setDroppable(boolean droppable) {
        this.droppable = droppable;
    }

    public void setUseRuntimeTableName(boolean useRuntimeTableName) {
        this.useRuntimeTableName = useRuntimeTableName;
    }

    public boolean isUseRuntimeTableName() {
        return this.useRuntimeTableName;
    }

    public String getBlockSizeUnit() {
        return this.blockSizeUnit;
    }

    public void setBlockSizeUnit(String blockSizeUnit) {
        this.blockSizeUnit = blockSizeUnit;
    }

    public String getTimeValuePattern() {
        return this.timeValuePattern;
    }

    public void setTimeValuePattern(String timeValuePattern) {
        this.timeValuePattern = timeValuePattern;
    }

    public String getDatetimeValuePattern() {
        return this.datetimeValuePattern;
    }

    public void setDatetimeValuePattern(String datetimeValuePattern) {
        this.datetimeValuePattern = datetimeValuePattern;
    }

    public String getTimestampTzValuePattern() {
        return this.timestampTzValuePattern;
    }

    public void setTimestampTzValuePattern(String timestampTzValuePattern) {
        this.timestampTzValuePattern = timestampTzValuePattern;
    }

    public String getTimestampLtzValuePattern() {
        return this.timestampLtzValuePattern;
    }

    public void setTimestampLtzValuePattern(String timestampLtzValuePattern) {
        this.timestampLtzValuePattern = timestampLtzValuePattern;
    }

    public String getDateValuePattern() {
        return this.dateValuePattern;
    }

    public void setDateValuePattern(String dateValuePattern) {
        this.dateValuePattern = dateValuePattern;
    }

    public String getTimestampValuePattern() {
        return this.timestampValuePattern;
    }

    public void setTimestampValuePattern(String timestampValuePattern) {
        this.timestampValuePattern = timestampValuePattern;
    }

    public UploadBehavior getUploadBehavior() {
        return this.uploadBehavior;
    }

    public void setUploadBehavior(UploadBehavior uploadBehavior) {
        this.uploadBehavior = uploadBehavior;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public boolean isPreserveZeroDatetime() {
        return this.preserveZeroDatetime;
    }

    public void setPreserveZeroDatetime(boolean preserveZeroDatetime) {
        this.preserveZeroDatetime = preserveZeroDatetime;
    }

    public boolean isCompactSchema() {
        return this.compactSchema;
    }

    public void setCompactSchema(boolean compactSchema) {
        this.compactSchema = compactSchema;
    }
}

