/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model;

import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.context.SqlContext;
import com.oceanbase.tools.loaddump.parser.record.Record;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;

public class Insertion
implements Serializable {
    private static final long serialVersionUID = -3924066851740506161L;
    private long partitionId;
    private boolean retry;
    private boolean commit;
    private Mode mode = Mode.BATCH;
    private boolean retried;
    private SqlContext sqlContext;
    private long byteSize;
    private SubFile subFile;
    private String leaderServer;
    private List<Record> recordList;

    public Insertion(SubFile subFile, long partitionId, boolean isShouldRetry) {
        this.subFile = subFile;
        this.retry = isShouldRetry;
        this.partitionId = partitionId;
    }

    public String getSchema() {
        return this.getSubFile().getSchemaName();
    }

    public String getTable() {
        return this.getSubFile().getObjectName();
    }

    public int getRecordCount() {
        return Optional.ofNullable(this.getRecordList()).map(List::size).orElse(0);
    }

    public void clearAll() {
        this.byteSize = 0L;
        this.retry = false;
        this.retried = false;
        this.mode = Mode.BATCH;
        if (this.sqlContext != null) {
            this.sqlContext.clearAll();
            this.sqlContext = null;
        }
        if (this.recordList != null) {
            for (Record record : this.recordList) {
                record.clearAll();
            }
            this.recordList.clear();
            this.recordList = null;
        }
    }

    public Insertion() {
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(long partitionId) {
        this.partitionId = partitionId;
    }

    public boolean isRetry() {
        return this.retry;
    }

    public void setRetry(boolean retry) {
        this.retry = retry;
    }

    public boolean isCommit() {
        return this.commit;
    }

    public void setCommit(boolean commit) {
        this.commit = commit;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public boolean isRetried() {
        return this.retried;
    }

    public void setRetried(boolean retried) {
        this.retried = retried;
    }

    public SqlContext getSqlContext() {
        return this.sqlContext;
    }

    public void setSqlContext(SqlContext sqlContext) {
        this.sqlContext = sqlContext;
    }

    public long getByteSize() {
        return this.byteSize;
    }

    public void setByteSize(long byteSize) {
        this.byteSize = byteSize;
    }

    public SubFile getSubFile() {
        return this.subFile;
    }

    public void setSubFile(SubFile subFile) {
        this.subFile = subFile;
    }

    public String getLeaderServer() {
        return this.leaderServer;
    }

    public void setLeaderServer(String leaderServer) {
        this.leaderServer = leaderServer;
    }

    public List<Record> getRecordList() {
        return this.recordList;
    }

    public void setRecordList(List<Record> recordList) {
        this.recordList = recordList;
    }

    public static enum Mode {
        SERIAL,
        BATCH;

    }
}

