/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model.storage;

import com.oceanbase.tools.loaddump.common.enums.StorageType;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.vmoption.JavaOpts;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;

public abstract class BaseStorageConfig {
    protected String specifiedLocalPath;
    protected boolean noNestedDir;
    protected String path;

    public abstract Configuration getHadoopConfiguration();

    public BaseStorageConfig(String specifiedLocalPath, String path) {
        this.specifiedLocalPath = specifiedLocalPath;
        this.path = path;
    }

    public abstract StorageType getStorageType();

    public abstract String getUri();

    public String assembleDestPath(File file) {
        String key = JavaOpts.isBackupRestoreMode || this.noNestedDir ? FileUtils.toPath(this.path, file.getName()) : FileUtils.toPath(this.path, StringUtils.substringAfterLast((String)file.getAbsolutePath(), (String)this.specifiedLocalPath));
        return StringUtils.isEmpty((CharSequence)this.path) ? key.substring(1) : key;
    }

    public BaseStorageConfig() {
    }

    public String getSpecifiedLocalPath() {
        return this.specifiedLocalPath;
    }

    public void setSpecifiedLocalPath(String specifiedLocalPath) {
        this.specifiedLocalPath = specifiedLocalPath;
    }

    public boolean isNoNestedDir() {
        return this.noNestedDir;
    }

    public void setNoNestedDir(boolean noNestedDir) {
        this.noNestedDir = noNestedDir;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

