/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model.storage.remote.cloud;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.enums.StorageType;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.AbstractCloudStorageConfig;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import org.apache.hadoop.conf.Configuration;

public class S3StorageConfig
extends AbstractCloudStorageConfig {
    private String storageClass;
    protected String region;

    @Override
    public StorageType getStorageType() {
        return StorageType.AMAZON_S3;
    }

    @Override
    public Configuration getHadoopConfiguration() {
        Configuration conf = new Configuration();
        conf.set("fs.s3a.endpoint.region", this.region);
        conf.set("fs.s3a.access.key", this.accessKey);
        conf.set("fs.s3a.secret.key", this.secretKey);
        conf.set("fs.s3a.impl", "org.apache.hadoop.fs.s3a.S3AFileSystem");
        return conf;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public static class Builder {
        S3StorageConfig target = new S3StorageConfig();

        public Builder region(String region) {
            this.target.region = region;
            return this;
        }

        public Builder path(String path) {
            this.target.path = path;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.target.endpoint = endpoint;
            return this;
        }

        public Builder bucket(String bucket) {
            this.target.bucket = bucket;
            return this;
        }

        public Builder accessKey(String accessKey) {
            this.target.accessKey = accessKey;
            return this;
        }

        public Builder secretKey(String secretKey) {
            this.target.secretKey = secretKey;
            return this;
        }

        public Builder aclString(String aclString) {
            this.target.aclString = aclString;
            return this;
        }

        public Builder storageClass(String storageClass) {
            this.target.storageClass = storageClass;
            return this;
        }

        public S3StorageConfig build() {
            Preconditions.checkArgument((this.target.region != null || this.target.endpoint != null ? 1 : 0) != 0, (Object)"Either region or endpoint must be specified");
            Preconditions.checkArgument((this.target.accessKey != null ? 1 : 0) != 0, (Object)"AccessKey must be specified");
            Preconditions.checkArgument((this.target.secretKey != null ? 1 : 0) != 0, (Object)"SecretKey must be specified");
            this.target.uri = FileUtils.toPath("s3://", this.target.bucket, this.target.path);
            return this.target;
        }
    }
}

