/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.common.model.storage.remote.hdfs;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.enums.StorageType;
import com.oceanbase.tools.loaddump.common.model.storage.BaseStorageConfig;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.security.UserGroupInformation;

public class HdfsStorageConfig
extends BaseStorageConfig {
    private String hdfsUri;
    private String authority;
    private String user;
    private String keytabFile;
    private String hdfsSiteFile;
    private String coreSiteFile;
    private String krb5ConfFile;
    private transient Configuration hadoopConfiguration;

    @Override
    public Configuration getHadoopConfiguration() {
        if (this.hadoopConfiguration != null) {
            return this.hadoopConfiguration;
        }
        Configuration hadoopConf = new Configuration();
        if (StringUtils.isNotBlank(this.coreSiteFile)) {
            Preconditions.checkArgument((boolean)new File(this.coreSiteFile).exists(), (String)"File: \"%s\" is not exists", (Object)this.coreSiteFile);
            hadoopConf.addResource(new Path(this.coreSiteFile));
        }
        if (StringUtils.isNotBlank(this.hdfsSiteFile)) {
            Preconditions.checkArgument((boolean)new File(this.hdfsSiteFile).exists(), (String)"File: \"%s\" is not exists", (Object)this.hdfsSiteFile);
            hadoopConf.addResource(new Path(this.hdfsSiteFile));
        }
        hadoopConf.set("fs.hdfs.impl.disable.cache", "true");
        hadoopConf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
        if (StringUtils.isNotBlank(this.keytabFile)) {
            hadoopConf.set("hadoop.security.authentication", "kerberos");
        }
        if (StringUtils.isNotBlank(this.krb5ConfFile)) {
            Preconditions.checkArgument((boolean)new File(this.krb5ConfFile).exists(), (String)"File: \"%s\" is not exists", (Object)this.krb5ConfFile);
            System.setProperty("java.security.krb5.conf", this.krb5ConfFile);
        }
        this.hadoopConfiguration = hadoopConf;
        return hadoopConf;
    }

    public FileSystem createHdfsSystem() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(this.hdfsUri), (Object)"Hdfs URI is null");
        try {
            Configuration conf = this.getHadoopConfiguration();
            UserGroupInformation.setConfiguration((Configuration)conf);
            if (StringUtils.isNotBlank(this.keytabFile)) {
                Preconditions.checkArgument((boolean)new File(this.keytabFile).exists(), (String)"File: \"%s\" is not exists", (Object)this.keytabFile);
                UserGroupInformation.loginUserFromKeytab((String)this.getUser(), (String)this.keytabFile);
            }
            return FileSystem.get((Configuration)conf);
        }
        catch (Exception e) {
            throw new RuntimeException("Create hdfs system failed", e);
        }
    }

    public String toString() {
        return "HdfsStorageConfig{hdfsUri='" + this.hdfsUri + '\'' + ", authority='" + this.authority + '\'' + ", user='" + this.user + '\'' + ", keytabFile='" + this.keytabFile + '\'' + ", hdfsSiteFile='" + this.hdfsSiteFile + '\'' + ", coreSiteFile='" + this.coreSiteFile + '\'' + ", krb5ConfFile='" + this.krb5ConfFile + '\'' + ", path='" + this.path + '\'' + '}';
    }

    @Override
    public StorageType getStorageType() {
        return StorageType.HADOOP_HDFS;
    }

    @Override
    public String getUri() {
        return this.hdfsUri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getHdfsUri() {
        return this.hdfsUri;
    }

    public void setHdfsUri(String hdfsUri) {
        this.hdfsUri = hdfsUri;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getKeytabFile() {
        return this.keytabFile;
    }

    public void setKeytabFile(String keytabFile) {
        this.keytabFile = keytabFile;
    }

    public void setHdfsSiteFile(String hdfsSiteFile) {
        this.hdfsSiteFile = hdfsSiteFile;
    }

    public void setCoreSiteFile(String coreSiteFile) {
        this.coreSiteFile = coreSiteFile;
    }

    public void setKrb5ConfFile(String krb5ConfFile) {
        this.krb5ConfFile = krb5ConfFile;
    }

    public static class Builder {
        HdfsStorageConfig target = new HdfsStorageConfig();

        public Builder hdfsSiteFile(String hdfsSiteFile) {
            this.target.hdfsSiteFile = hdfsSiteFile;
            return this;
        }

        public Builder coreSiteFile(String coreSiteFile) {
            this.target.coreSiteFile = coreSiteFile;
            return this;
        }

        public Builder krb5ConfFile(String krb5ConfFile) {
            this.target.krb5ConfFile = krb5ConfFile;
            return this;
        }

        public Builder user(String user) {
            this.target.user = user;
            return this;
        }

        public Builder keytabFile(String keytabFile) {
            this.target.keytabFile = keytabFile;
            return this;
        }

        public Builder hdfsUri(String hdfsUri) {
            this.target.hdfsUri = hdfsUri;
            return this;
        }

        public Builder authority(String authority) {
            this.target.authority = authority;
            return this;
        }

        public Builder path(String path) {
            this.target.path = path;
            return this;
        }

        public HdfsStorageConfig build() {
            return this.target;
        }
    }
}

