/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    private final String prefix;
    private final boolean daemon;
    private final int priority;
    private final Thread.UncaughtExceptionHandler handler;
    private final AtomicInteger sequence = new AtomicInteger(0);

    public DaemonThreadFactory(String prefix) {
        this(prefix, true, 5, null);
    }

    public DaemonThreadFactory(String prefix, boolean daemon, int priority, Thread.UncaughtExceptionHandler handler) {
        this.prefix = prefix;
        this.daemon = daemon;
        this.priority = priority;
        this.handler = handler;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(r);
        thread.setDaemon(this.daemon);
        thread.setName(this.prefix + this.sequence.getAndIncrement());
        thread.setPriority(this.priority);
        if (this.handler != null) {
            thread.setUncaughtExceptionHandler(this.handler);
        }
        return thread;
    }
}

