/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.concurrent;

import com.oceanbase.tools.loaddump.concurrent.FlowLimiter;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class SemaphoreLimiter
implements FlowLimiter {
    private final int threshold;
    private final Semaphore semaphore;

    public SemaphoreLimiter(int threshold) {
        this.threshold = threshold;
        this.semaphore = new Semaphore(threshold, false);
    }

    public void acquire(int permits) throws ResourceInsufficientException, InterruptedException {
        this.checkResource(permits);
        this.semaphore.acquire(permits);
    }

    public void acquireUninterruptibly(int permits) throws ResourceInsufficientException {
        this.checkResource(permits);
        this.semaphore.acquireUninterruptibly(permits);
    }

    @Override
    public boolean tryAcquire(int permits) throws ResourceInsufficientException {
        this.checkResource(permits);
        return this.semaphore.tryAcquire(permits);
    }

    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws ResourceInsufficientException, InterruptedException {
        this.checkResource(permits);
        return this.semaphore.tryAcquire(permits, timeout, unit);
    }

    @Override
    public void release(int permits) {
        this.semaphore.release(permits);
    }

    @Override
    public int getPermits() {
        return this.threshold;
    }

    private void checkResource(int permits) throws ResourceInsufficientException {
        if (permits > this.threshold) {
            throw new ResourceInsufficientException("Resource is not enough(" + permits + " > " + this.threshold + "). Reduce batch size or increase ob_sql_work_area_percentage.");
        }
    }

    public static class ResourceInsufficientException
    extends Exception {
        private static final long serialVersionUID = 5016236780709694571L;

        public ResourceInsufficientException(String message) {
            super(message);
        }

        @Override
        public Throwable fillInStackTrace() {
            return null;
        }
    }
}

