/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.decrypt;

import com.oceanbase.tools.loaddump.utils.ArrayUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import java.io.File;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import javax.crypto.Cipher;

public class OpenSslDecryptor {
    public static String decrypt(String encryptedRaw, String privateKeyPath) throws Exception {
        byte[] encryptedPwdBytes = FileUtils.readFileToByteArray((File)new File(encryptedRaw));
        PrivateKey privateKey = OpenSslDecryptor.loadPrivateKey(privateKeyPath);
        return OpenSslDecryptor.decrypt(privateKey, encryptedPwdBytes);
    }

    private static String decrypt(PrivateKey privateKey, byte[] encryptedPwd) throws Exception {
        if (privateKey == null || ArrayUtils.isEmpty((byte[])encryptedPwd)) {
            throw new Exception("The private key or encrypted password is null");
        }
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        byte[] decryptPwd = cipher.doFinal(encryptedPwd);
        return new String(decryptPwd);
    }

    public static PrivateKey loadPrivateKey(String privateKeyPath) throws Exception {
        List lines = FileUtils.readLines((File)new File(privateKeyPath), (String)"UTF-8");
        String key = lines.stream().filter(l -> !l.startsWith("-")).collect(Collectors.joining());
        byte[] buffer = Base64.getDecoder().decode(key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
        return KeyFactory.getInstance("RSA").generatePrivate(keySpec);
    }
}

