/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.record;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.tools.loaddump.base.State;
import com.oceanbase.tools.loaddump.common.constants.JdbcType;
import com.oceanbase.tools.loaddump.common.model.ColumnInfo;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.TableEntryInfo;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.concurrent.ExecutorTemplate;
import com.oceanbase.tools.loaddump.concurrent.ThreadPoolBuilder;
import com.oceanbase.tools.loaddump.context.TaskContext;
import com.oceanbase.tools.loaddump.dumper.AbstractDumper;
import com.oceanbase.tools.loaddump.dumper.task.AbstractDumpTask;
import com.oceanbase.tools.loaddump.dumper.task.record.RecordDumpTask;
import com.oceanbase.tools.loaddump.factory.FileWriterManager;
import com.oceanbase.tools.loaddump.function.AbstractUserDefinedFunction;
import com.oceanbase.tools.loaddump.function.SqlFunction;
import com.oceanbase.tools.loaddump.function.context.ControlDescription;
import com.oceanbase.tools.loaddump.generator.RecordDumpTaskGenerator;
import com.oceanbase.tools.loaddump.manager.ControlManager;
import com.oceanbase.tools.loaddump.metrics.MetricRegistry;
import com.oceanbase.tools.loaddump.metrics.Slf4jReporter;
import com.oceanbase.tools.loaddump.partition.AbstractPartitionHelper;
import com.oceanbase.tools.loaddump.partition.MySqlPartitionHelper;
import com.oceanbase.tools.loaddump.partition.OraclePartitionHelper;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingFileWriterV2;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordFileDumper
extends AbstractDumper<RecordDumpTask> {
    private static final Logger log = LoggerFactory.getLogger(RecordFileDumper.class);
    private final AbstractPartitionHelper partitionHelper = this.createPartitionHelper();
    private final FileWriterManager fileWriterManager;

    public RecordFileDumper(DumpParameter parameter) {
        super(parameter);
        this.taskGenerator = this.createDumpTaskGenerator();
        FileWriterManager.Builder builder = FileWriterManager.builder().filePath(parameter.getDefaultTableDataPath()).fileName(parameter.getOutputFile()).fileEncoding(parameter.getFileEncoding()).fileSuffix(parameter.getFileSuffix()).dataFormat(parameter.getDataFormat()).blockSizeUnit(parameter.getBlockSizeUnit()).blockSize(parameter.getBlockSize()).commitSize(parameter.getCommitSize()).storageConfig(parameter.getStorageConfig());
        this.fileWriterManager = builder.build();
    }

    public RecordDumpTaskGenerator createDumpTaskGenerator() {
        try {
            if (StringUtils.isEmpty(this.parameter.getQuerySql())) {
                return this.createRecordDumpTaskGenerator();
            }
            return new RecordDumpTaskGenerator(this.parameter);
        }
        catch (Exception e) {
            log.error("Create record dump task generator failed. Reason: {}.", (Object)ExceptionUtils.getRootCauseMessage(e), (Object)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public TaskContext dumpSchemaAsync() {
        throw new UnsupportedOperationException("Not implement");
    }

    @Override
    public TaskContext dumpRecordAsync() throws Exception {
        super.checkState();
        this.defaultExecutor = new ThreadPoolBuilder().setCorePoolSize(this.parameter.getThreads()).setMaximumPoolSize(this.parameter.getThreads()).setQueueSize(this.dumpTasks.size()).setThreadPrefixName("dump-record-thread-").build();
        MetricRegistry registry = new MetricRegistry();
        this.meter = registry.meter("Dump Performance Monitor: ");
        Map<String, Long> tableTaskCntMap = this.dumpTasks.stream().collect(Collectors.groupingBy(AbstractDumpTask::getObjectName, Collectors.counting()));
        for (AbstractDumpTask dumpTask : this.dumpTasks) {
            if (dumpTask instanceof RecordDumpTask) {
                RecordDumpTask recordDumpTask = (RecordDumpTask)dumpTask;
                String tableName = recordDumpTask.getObjectName();
                Map<String, Object> colTypeMap = this.parameter.getDatabase().getTableInfo(recordDumpTask.getObjectName()).getColumnTypeMap();
                AbstractRollingFileWriterV2 fileWriter = this.fileWriterManager.getFileWriter(tableName, colTypeMap, tableTaskCntMap.get(tableName).intValue());
                recordDumpTask.setFileWriter(fileWriter);
                recordDumpTask.setMeter(this.meter);
                recordDumpTask.initialize(this.parameter);
            }
            this.defaultExecutor.submit(dumpTask);
        }
        Slf4jReporter.forRegistry(registry).scheduleOn(this.logReporterExecutor).build().start(5L, TimeUnit.SECONDS);
        log.info("Start {} record dump threads for {} dump tasks finished", (Object)this.parameter.getThreads(), (Object)this.dumpTasks.size());
        this.state = State.RUNNING;
        return this;
    }

    public void initControlManager() {
        ControlManager controlManager = this.parameter.getControlManager();
        if (Objects.isNull(controlManager)) {
            return;
        }
        for (TableInfo tableInfo : this.parameter.getDatabase().getTableInfoMap().values()) {
            String schemaName = tableInfo.getSchema();
            String tableName = tableInfo.getTable();
            for (ColumnInfo columnInfo : tableInfo.getColumnInfoList()) {
                List<SqlFunction> callStacks;
                ControlDescription control;
                String columnName = columnInfo.getColumnName();
                if (this.parameter.isUseRuntimeTableName()) {
                    schemaName = columnInfo.getSchemaName();
                    tableName = columnInfo.getTableName();
                }
                if (Objects.isNull(control = controlManager.getControl(schemaName, tableName, columnName)) || CollectionUtils.isEmpty(callStacks = control.getCallStacks())) continue;
                for (SqlFunction sqlFunction : callStacks) {
                    if (!(sqlFunction instanceof AbstractUserDefinedFunction)) continue;
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put("column_name", columnName);
                    paramMap.put("table_name", tableName);
                    paramMap.put("data_type", tableInfo.getColumnType(columnName));
                    ((AbstractUserDefinedFunction)sqlFunction).setParams(paramMap);
                }
            }
        }
    }

    private RecordDumpTaskGenerator createRecordDumpTaskGenerator() throws Exception {
        boolean hasNoSysPrivilegePreviousV4;
        HashSet tableInfoCopies = Sets.newHashSet(this.parameter.getDatabase().getTableInfoMap().values());
        ConcurrentHashMap<String, TableEntryInfo> tableEntryInfoMap = new ConcurrentHashMap<String, TableEntryInfo>(tableInfoCopies.size());
        AtomicLong remain = new AtomicLong(tableInfoCopies.size());
        Iterator iter = tableInfoCopies.iterator();
        while (iter.hasNext()) {
            TableInfo tableInfoCopy = (TableInfo)iter.next();
            if (!tableInfoCopy.isEmptyTable()) continue;
            iter.remove();
            tableEntryInfoMap.put(tableInfoCopy.getTable(), new TableEntryInfo(true));
            remain.decrementAndGet();
        }
        RecordDumpTaskGenerator generator = new RecordDumpTaskGenerator(this.parameter);
        generator.setMetadataProvider(this.metadataProvider);
        if (remain.get() < 1L) {
            log.info("Ignore to query table entry for any tables as they are all empty in the schema");
            generator.setTableEntryInfoMap(tableEntryInfoMap);
            return generator;
        }
        boolean isPreviousV4 = this.serverMode.isPreviousV4();
        boolean hasNoSysPrivilege = this.parameter.getConnectionKey().hasNoSysPrivileges();
        boolean isSnapshot = this.parameter.isSnapshot();
        boolean isNeedQueryMacros = isSnapshot && !hasNoSysPrivilege && isPreviousV4;
        boolean isFlashbackUsed = StringUtils.isNotBlank(this.parameter.getFlashbackScn()) || StringUtils.isNotBlank(this.parameter.getFlashbackTimestamp());
        boolean bl = hasNoSysPrivilegePreviousV4 = hasNoSysPrivilege && isPreviousV4;
        if (isSnapshot) {
            long dataVersion = this.metadataProvider.queryLatestMergedVersion(this.serverMode);
            log.info("Query the last merged version success. Last merged version: {}.", (Object)dataVersion);
            if (dataVersion <= 1L) {
                log.warn("Data can not be dumped out as oceanbase cluster has not merged yet. Data Version: {}", (Object)dataVersion);
            }
            generator.setDataVersion(dataVersion);
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        ExecutorTemplate<Void> template = new ExecutorTemplate<Void>("query-table-entry-info-", this.parameter.getThreads());
        for (TableInfo tableInfoCopy : tableInfoCopies) {
            template.submit(() -> {
                remain.decrementAndGet();
                String table = tableInfoCopy.getTable();
                TableEntryInfo tableEntryInfo = tableEntryInfoMap.computeIfAbsent(table, t -> new TableEntryInfo());
                if (hasNoSysPrivilegePreviousV4) {
                    log.warn("Ignore to query table entry for table: \"{}\". (As sys privilege is required prior to v4.0).", (Object)table);
                } else {
                    log.info("Querying table entry for: \"{}\"...", (Object)table);
                    TableEntry tableEntry = this.partitionHelper.queryTableEntry(table);
                    if (tableEntry == null) {
                        log.warn("Table entry for \"{}\" is null, use 'no-sys' approach instead.", (Object)table);
                    } else {
                        tableEntryInfo.setTableEntry(tableEntry);
                        if (isNeedQueryMacros) {
                            Stopwatch sw4GetLeaderLocation = Stopwatch.createStarted();
                            try (Connection conn = this.sessionManager.getPooledSysConnection();){
                                ArrayList partIds = Lists.newArrayList(tableEntry.getPartIdNameMap().keySet());
                                tableEntryInfo.setLeaderMap(this.partitionHelper.getTableEntryExtractor().queryLeaderLocationMap(conn, tableEntry, (List)partIds));
                                log.debug("Query leader location for table: \"{}\" before query macro ranges success. Elapsed: {}", (Object)table, (Object)sw4GetLeaderLocation);
                            }
                        }
                    }
                }
                if (!isSnapshot && !isFlashbackUsed && tableEntryInfo.getTableEntry() == null) {
                    log.info("Query partitions for table: \"{}\"... (No sys)", (Object)table);
                    this.partitionHelper.queryPartitionsNoSys(table, tableEntryInfo);
                }
                try {
                    Stopwatch sw4GetConstraint = Stopwatch.createStarted();
                    tableEntryInfo.getSplitKeyColumns().addAll(this.querySplitKeyColumns(tableInfoCopy));
                    log.debug("Query split key for table: \"{}\" finished. Elapsed: {}", (Object)table, (Object)sw4GetConstraint);
                }
                catch (Exception e) {
                    log.error("Query split key for table: \"{}\" failed. Reason: {}", (Object)table, (Object)ExceptionUtils.getRootCauseMessage(e));
                    throw new IllegalStateException(e);
                }
                return null;
            });
        }
        template.waitForResult();
        generator.setTableEntryInfoMap(tableEntryInfoMap);
        log.info("Query all table entries success. Elapsed: {}", (Object)stopwatch);
        return generator;
    }

    private List<String> querySplitKeyColumns(TableInfo tableInfo) throws Exception {
        String schemaName = tableInfo.getSchema();
        String tableName = tableInfo.getTable();
        List<String> pkCols = this.metadataProvider.queryPrimaryKeyList(this.serverMode, schemaName, tableName);
        tableInfo.setPrimaryCols(pkCols);
        if (CollectionUtils.isNotEmpty(pkCols)) {
            return Lists.newArrayList(pkCols);
        }
        if (this.parameter.isEnableHiddenPk()) {
            tableInfo.addHiddenPk();
            return Lists.newArrayList((Object[])new String[]{"__pk_increment"});
        }
        tableInfo.setNotNullUniqueKeyMap(this.metadataProvider.queryNonNullUniqueKeyMap(this.serverMode, schemaName, tableName));
        if (MapUtils.isEmpty(tableInfo.getNotNullUniqueKeyMap())) {
            return Lists.newArrayList();
        }
        return this.findShortestLenUniqueKey(tableInfo);
    }

    private List<String> findShortestLenUniqueKey(TableInfo tableInfo) {
        Map<String, List<String>> uniqueKeyMap = tableInfo.getNotNullUniqueKeyMap();
        Collection<String> numericTypes = JdbcType.numerics();
        Collection<String> stringTypes = JdbcType.strings();
        Collection<String> datetimeTypes = JdbcType.datetimes();
        TreeMap<Integer, List> multimap = new TreeMap<Integer, List>();
        for (Map.Entry<String, List<String>> entry : uniqueKeyMap.entrySet()) {
            int totalScore = entry.getValue().size();
            for (String columnName : entry.getValue()) {
                String dataType = tableInfo.getColumnTypeName(columnName);
                if (numericTypes.contains(dataType)) {
                    ++totalScore;
                    continue;
                }
                if (stringTypes.contains(dataType)) {
                    totalScore += 2;
                    continue;
                }
                if (datetimeTypes.contains(dataType)) {
                    totalScore += 3;
                    continue;
                }
                totalScore += 4;
            }
            List uniqueConstraintNames = multimap.getOrDefault(totalScore, new ArrayList());
            uniqueConstraintNames.add(entry.getKey());
            multimap.putIfAbsent(totalScore, uniqueConstraintNames);
        }
        String uniqueConstraintName = (String)((List)multimap.firstEntry().getValue()).get(0);
        log.debug("Find the shortest length unique constraint success. Constraint name: \"{}\"", (Object)uniqueConstraintName);
        return uniqueKeyMap.get(uniqueConstraintName);
    }

    private AbstractPartitionHelper createPartitionHelper() {
        return this.serverMode.isOracleMode() ? new OraclePartitionHelper(this.connectionKey) : new MySqlPartitionHelper(this.connectionKey);
    }

    @Override
    public void shutdown() throws Exception {
        super.shutdown();
        this.fileWriterManager.close();
        this.dumpTasks.forEach(recordDumpTask -> ((RecordDumpTask)recordDumpTask).expireCache());
    }

    @Override
    public void shutdownNow() throws Exception {
        super.shutdownNow();
        this.fileWriterManager.close();
        this.dumpTasks.forEach(recordDumpTask -> ((RecordDumpTask)recordDumpTask).expireCache());
    }
}

