/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.factory;

import com.oceanbase.tools.loaddump.common.enums.StorageType;
import com.oceanbase.tools.loaddump.common.model.storage.BaseStorageConfig;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.OssStorageConfig;
import com.oceanbase.tools.loaddump.common.model.storage.remote.cloud.S3StorageConfig;
import com.oceanbase.tools.loaddump.common.model.storage.remote.hdfs.HdfsStorageConfig;
import com.oceanbase.tools.loaddump.resource.remote.FileUploader;
import com.oceanbase.tools.loaddump.resource.remote.hdfs.HdfsFileUploader;
import com.oceanbase.tools.loaddump.resource.remote.oss.OssFileUploader;
import com.oceanbase.tools.loaddump.resource.remote.s3.S3FileUploader;

public class FileUploaderFactory {
    public static FileUploader createFileUploader(BaseStorageConfig storageConfig, String filePath) {
        if (storageConfig.getStorageType() == StorageType.ALIYUN_OSS) {
            return new OssFileUploader((OssStorageConfig)storageConfig, filePath);
        }
        if (storageConfig.getStorageType() == StorageType.AMAZON_S3) {
            return new S3FileUploader((S3StorageConfig)storageConfig, filePath);
        }
        if (storageConfig.getStorageType() == StorageType.HADOOP_HDFS) {
            return new HdfsFileUploader((HdfsStorageConfig)storageConfig, filePath);
        }
        throw new IllegalArgumentException("Unsupported storage: " + (Object)((Object)storageConfig.getStorageType()));
    }
}

