/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.function.mask;

import com.oceanbase.tools.loaddump.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.function.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.utils.StringUtils;

public class MaskLastNFunction
extends AbstractBuiltinFunction {
    private final String upperMask;
    private final String lowerMask;
    private final String numMask;
    private final int lastN;

    public MaskLastNFunction() {
        this("X", "x", "n", 0);
    }

    public MaskLastNFunction(String upperMask) {
        this(upperMask, "x", "n", 0);
    }

    public MaskLastNFunction(String upperMask, String lowerMask) {
        this(upperMask, lowerMask, "n", 0);
    }

    public MaskLastNFunction(String upperMask, String lowerMask, String numMask) {
        this(upperMask, lowerMask, numMask, 0);
    }

    public MaskLastNFunction(String upperMask, String lowerMask, String numMask, int lastN) {
        this.upperMask = upperMask;
        this.lowerMask = lowerMask;
        this.numMask = numMask;
        this.lastN = lastN;
    }

    @Override
    public String getName() {
        return SqlFunctions.MASK_LAST_N_FUNCTION.name();
    }

    @Override
    public String invoke(String ... varargs) {
        return this.maskLastN(varargs == null ? null : varargs[0]);
    }

    private String maskLastN(String origin) {
        if (StringUtils.isEmpty(origin) || this.lastN <= 0) {
            return origin;
        }
        StringBuilder sb = new StringBuilder(origin.length());
        int n = Math.min(this.lastN, origin.length());
        sb.append(origin, 0, origin.length() - n);
        for (int i = origin.length() - n; i < origin.length(); ++i) {
            char c = origin.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append(this.upperMask);
                continue;
            }
            if (Character.isLowerCase(c)) {
                sb.append(this.lowerMask);
                continue;
            }
            if (Character.isDigit(c)) {
                sb.append(this.numMask);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

