/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.function.string;

import com.oceanbase.tools.loaddump.function.AbstractBuiltinFunction;
import com.oceanbase.tools.loaddump.function.enums.SqlFunctions;
import com.oceanbase.tools.loaddump.utils.StringUtils;

public class RpadFunction
extends AbstractBuiltinFunction {
    private final int paddedLength;
    private String padString = " ";

    public RpadFunction(int paddedLength) {
        this(paddedLength, " ");
    }

    public RpadFunction(int paddedLength, String padString) {
        this.paddedLength = paddedLength;
        this.padString = padString;
    }

    @Override
    public String getName() {
        return SqlFunctions.RPAD.name();
    }

    @Override
    public String invoke(String ... varargs) {
        return varargs == null ? null : this.rpad(varargs[0]);
    }

    private String rpad(String value) {
        if (value == null) {
            return null;
        }
        int length = value.length();
        if (this.paddedLength <= length) {
            return value.substring(0, this.paddedLength);
        }
        return StringUtils.rightPad((String)value, (int)this.paddedLength, (String)this.padString);
    }

    public int getPaddedLength() {
        return this.paddedLength;
    }

    public String getPadString() {
        return this.padString;
    }

    public void setPadString(String padString) {
        this.padString = padString;
    }
}

