/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.loader;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.base.State;
import com.oceanbase.tools.loaddump.common.metadata.MetadataProvider;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.Progress;
import com.oceanbase.tools.loaddump.common.model.RuntimeMetrics;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.common.model.Summary;
import com.oceanbase.tools.loaddump.common.model.TaskDetail;
import com.oceanbase.tools.loaddump.context.TaskContext;
import com.oceanbase.tools.loaddump.loader.ILoader;
import com.oceanbase.tools.loaddump.manager.SessionManager;
import com.oceanbase.tools.loaddump.metrics.Meter;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoader
extends TaskContext
implements ILoader {
    private static final Logger log = LoggerFactory.getLogger(AbstractLoader.class);
    protected State state = State.INITIAL;
    protected Meter meter;
    protected String filePath;
    protected String fileSuffix;
    protected String fileNameRegExp;
    protected String fileEncoding;
    protected AtomicBoolean supervisor;
    protected LoadParameter parameter;
    protected ConnectionKey connectionKey;
    protected SessionManager sessionManager;
    protected MetadataProvider metadataProvider;
    protected ExecutorService writerExecutor;
    protected List<TaskDetail> taskDetailList;
    protected Map<String, String> sourceTargetTableMap;
    private RuntimeMetrics runtimeMetrics;

    public AbstractLoader(LoadParameter parameter) {
        this.parameter = parameter;
        this.supervisor = new AtomicBoolean(true);
        this.taskDetailList = new ArrayList<TaskDetail>(16);
        this.filePath = parameter.getFilePath();
        this.fileSuffix = parameter.getFileSuffix();
        this.fileNameRegExp = parameter.getFileNameRegExp();
        this.fileEncoding = parameter.getFileEncoding();
        this.sourceTargetTableMap = parameter.getSourceTargetTableMap();
        this.connectionKey = parameter.getConnectionKey();
        this.sessionManager = parameter.getConnectionKey().getSessionManager();
        this.metadataProvider = parameter.getConnectionKey().getMetadataProvider();
    }

    protected void checkState() throws Exception {
        Preconditions.checkState((this.state != State.INITIAL ? 1 : 0) != 0, (Object)"Not Prepared");
        Preconditions.checkState((this.state != State.RUNNING ? 1 : 0) != 0, (Object)"It's already running");
        Preconditions.checkState((this.state != State.TERMINATE ? 1 : 0) != 0, (Object)"It's already terminated");
    }

    protected abstract List<SubFile> generateSubFiles() throws Exception;

    @Override
    public Summary getSummary() {
        return new Summary("All Load Tasks Finished", this.getAllTaskDetails());
    }

    @Override
    public Progress getProgress() {
        List<SubFile> subFiles = this.parameter.getSubFiles();
        double totalPercent = 0.0;
        int loadedFiles = 0;
        int totalFiles = subFiles.size();
        for (SubFile subFile : subFiles) {
            if (subFile.isFinished()) {
                ++loadedFiles;
            }
            totalPercent += subFile.getProgress();
        }
        BigDecimal per = new BigDecimal(totalPercent / (double)totalFiles);
        double percent = per.setScale(2, RoundingMode.HALF_UP).doubleValue();
        percent = percent > 100.0 ? 99.99 : percent;
        return new Progress(loadedFiles, totalFiles - loadedFiles, percent);
    }

    @Override
    public Collection<TaskDetail> getAllTaskDetails() {
        return Collections.unmodifiableCollection(this.taskDetailList);
    }

    @Override
    public Collection<TaskDetail> getFailureTaskDetails() {
        List<TaskDetail> taskDetails = this.taskDetailList;
        if (CollectionUtils.isEmpty(taskDetails)) {
            log.warn("The task details are empty, please check it....");
            return Lists.newArrayList();
        }
        return taskDetails.stream().filter(e -> e != null && e.isFailure()).collect(Collectors.toList());
    }

    @Override
    public boolean isAllTasksFinished() {
        List<TaskDetail> taskDetails = this.taskDetailList;
        if (CollectionUtils.isEmpty(taskDetails)) {
            log.warn("The task details are empty, please check it....");
            return false;
        }
        return taskDetails.stream().allMatch(e -> e != null && e.isFinished());
    }

    @Override
    public boolean isAllTasksSuccessed() {
        List<TaskDetail> taskDetails = this.taskDetailList;
        if (CollectionUtils.isEmpty(taskDetails)) {
            log.warn("The task details are empty, please check it....");
            return false;
        }
        return taskDetails.stream().allMatch(e -> e != null && e.isSuccess());
    }

    @Override
    public RuntimeMetrics getRuntimeMetrics() {
        if (this.runtimeMetrics == null) {
            this.runtimeMetrics = new RuntimeMetrics();
        }
        this.runtimeMetrics.setThroughput(this.meter != null ? this.meter.getThroughput() : 0L);
        this.runtimeMetrics.setMeanThroughputRate(this.meter != null ? this.meter.getMeanThroughputRate() : 0.0);
        this.runtimeMetrics.setProgress(this.getProgress().getProgress());
        this.runtimeMetrics.setCount(this.taskDetailList.stream().mapToLong(TaskDetail::getCount).sum());
        this.runtimeMetrics.setTotal(this.taskDetailList.stream().mapToLong(TaskDetail::getTotal).sum());
        return this.runtimeMetrics;
    }

    public void setWriterExecutor(ExecutorService writerExecutor) {
        this.writerExecutor = writerExecutor;
    }

    public void setSourceTargetTableMap(Map<String, String> sourceTargetTableMap) {
        this.sourceTargetTableMap = sourceTargetTableMap;
    }

    public void setRuntimeMetrics(RuntimeMetrics runtimeMetrics) {
        this.runtimeMetrics = runtimeMetrics;
    }
}

