/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.loader.record;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.concurrent.ExecutorTemplate;
import com.oceanbase.tools.loaddump.concurrent.ThreadPoolBuilder;
import com.oceanbase.tools.loaddump.factory.ResourceFinderFactory;
import com.oceanbase.tools.loaddump.loader.record.AbstractRecordFileLoader;
import com.oceanbase.tools.loaddump.metrics.Meter;
import com.oceanbase.tools.loaddump.parser.record.AbstractRecordParser;
import com.oceanbase.tools.loaddump.parser.record.Record;
import com.oceanbase.tools.loaddump.parser.record.csv.CsvFormat;
import com.oceanbase.tools.loaddump.reader.record.RecordFileReader;
import com.oceanbase.tools.loaddump.resource.Resource;
import com.oceanbase.tools.loaddump.resource.ResourceFinder;
import com.oceanbase.tools.loaddump.resource.local.LocalResourceFinder;
import com.oceanbase.tools.loaddump.strategy.AdaptiveBatchStrategy;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.SqlUtils;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordFileLoader
extends AbstractRecordFileLoader {
    private static final Logger log = LoggerFactory.getLogger(RecordFileLoader.class);
    private static final int MAX_FILE_COPIES = 40000;

    public RecordFileLoader(LoadParameter parameter) {
        super(parameter);
    }

    @Override
    protected List<SubFile> generateSubFiles() throws Exception {
        DataFormat dataFormat = this.parameter.getDataFormat();
        ResourceFinder<Resource> finder = ResourceFinderFactory.createResourceFinder(this.parameter);
        List<Resource> resources = finder.listRecordResources();
        this.findDataFilesForSpecifiedTables(resources);
        if (finder instanceof LocalResourceFinder && !dataFormat.isColumnOrientedFormat()) {
            return this.splitLargeSubFiles(resources);
        }
        AtomicInteger uidGenerator = new AtomicInteger(0);
        return resources.stream().map(r -> new SubFile((Resource)r, 0, 0L, r.getTotalSize(), dataFormat)).peek(s -> s.setUid(uidGenerator.getAndIncrement())).collect(Collectors.toList());
    }

    private List<SubFile> splitLargeSubFiles(List<Resource> resources) {
        long newBlockSize = this.resetBlockSize(resources);
        log.info("Splitting data files into {} logical chunks...", (Object)SqlUtils.convertUnit(newBlockSize));
        Stopwatch stopwatch = Stopwatch.createStarted();
        ExecutorTemplate<List> template = new ExecutorTemplate<List>("large-file-splitter-", Constants.AVAILABLE_CPUS);
        for (Resource resource : resources) {
            template.submit(() -> this.splitLargeSubFile(resource, newBlockSize));
        }
        List result = template.waitForResult();
        AtomicInteger uidGenerator = new AtomicInteger(0);
        List<SubFile> subFiles = result.stream().filter(org.apache.commons.collections.CollectionUtils::isNotEmpty).flatMap(e -> e.stream().filter(Objects::nonNull)).peek(s -> s.setUid(uidGenerator.getAndIncrement())).collect(Collectors.toList());
        log.info("Split {} data files to {} logical chunks success. Elapsed: {}", new Object[]{resources.size(), subFiles.size(), stopwatch});
        return subFiles;
    }

    private long resetBlockSize(List<Resource> resources) {
        if (this.blockSize > 0L && CollectionUtils.isNotEmpty(resources)) {
            int largeFileCount = 40000;
            long totalFileSize = 0L;
            for (Resource resource : resources) {
                long totalMegaByteSize = resource.getTotalSize();
                if (totalMegaByteSize > this.blockSize) {
                    totalFileSize += totalMegaByteSize;
                    continue;
                }
                --largeFileCount;
            }
            if (totalFileSize / this.blockSize > 40000L && largeFileCount > 0) {
                long newBlockSize = SqlUtils.powerOfTwo(totalFileSize / (long)largeFileCount);
                String rawUnit = SqlUtils.convertUnit(this.blockSize);
                String newUnit = SqlUtils.convertUnit(newBlockSize);
                log.info("Reset block size from {} to {} avoid generating too many logical chunks....", (Object)rawUnit, (Object)newUnit);
                return newBlockSize;
            }
        }
        return this.blockSize;
    }

    private List<SubFile> splitLargeSubFile(Resource resource, long blockSize) throws Exception {
        if (this.parameter.getDataFormat() == DataFormat.CSV) {
            if ("SAFE".equalsIgnoreCase(System.getProperty("file.split"))) {
                return FileUtils.splitCsvFileSafely(resource, blockSize, (CsvFormat)this.csvFormatMap.get(resource.getObjectName()));
            }
            return FileUtils.splitCsvFileUnsafely(resource, blockSize, (CsvFormat)this.csvFormatMap.get(resource.getObjectName()));
        }
        if (this.parameter.getDataFormat() == DataFormat.SQL) {
            if ("SAFE".equalsIgnoreCase(System.getProperty("file.split"))) {
                return FileUtils.splitSqlFileSafely(resource, blockSize);
            }
            return FileUtils.splitSqlFileUnsafely(resource, blockSize);
        }
        if (this.parameter.getDataFormat() == DataFormat.CUT || this.parameter.getDataFormat() == DataFormat.POS) {
            DataFormat dataFormat = this.parameter.getDataFormat();
            boolean skipHeader = this.parameter.isSkipHeader();
            boolean skipFooter = this.parameter.isSkipFooter();
            return FileUtils.splitTxtFileUnsafely(resource, blockSize, dataFormat, skipHeader, skipFooter, this.parameter.getLineSeparator());
        }
        throw new IllegalArgumentException("Unsupported data format: " + (Object)((Object)this.parameter.getDataFormat()));
    }

    private void findDataFilesForSpecifiedTables(List<Resource> resources) throws Exception {
        if (new File(this.filePath).isFile()) {
            List<String> tableNames = this.parameter.getDatabase().getTableNames();
            boolean isSingleTable = tableNames != null && tableNames.size() == 1;
            Preconditions.checkArgument((boolean)isSingleTable, (String)"Specified table count=(%s) is unexpected. As -f/--file is a file.", (int)tableNames.size());
            Preconditions.checkArgument((resources.size() == 1 ? 1 : 0) != 0, (String)"Searched resource count=(%s) is unexpected. As -f/--file is a file.", (int)resources.size());
            this.parameter.getDatabase().getTableInfo(tableNames.get(0)).setWithDatafiles(true);
            return;
        }
        for (Resource resource : resources) {
            String tableName = resource.getObjectName();
            this.parameter.getDatabase().getTableInfo(tableName).setWithDatafiles(tableName != null);
        }
    }

    @Override
    protected void startReader() throws Exception {
        int readerThreads = super.getReaderThreads();
        this.readerExecutor = new ThreadPoolBuilder().setCorePoolSize(readerThreads).setMaximumPoolSize(readerThreads).setQueueSize(this.parameter.getSubFiles().size()).setThreadPrefixName("record-file-loader-thread-").build();
        Meter enqueueMeter = this.registerMeter("1. Enqueue Performance Monitor: ");
        AdaptiveBatchStrategy adaptiveBatchStrategy = new AdaptiveBatchStrategy();
        for (SubFile tempSubFile : this.parameter.getSubFiles()) {
            String table = tempSubFile.getObjectName();
            TableInfo tableInfo = this.database.getTableInfo(table);
            tableInfo.setIgnoreUnhex(this.parameter.isIgnoreUnhex());
            RecordFileReader reader = new RecordFileReader(this.parameter);
            reader.setSubFile(tempSubFile);
            reader.setMeter(enqueueMeter);
            reader.setTableInfo(tableInfo);
            reader.setSupervisor(this.supervisor);
            reader.setBufferGroup(this.bufferGroup);
            reader.setLoadCtx(this.loadCtx);
            reader.setAdaptiveBatchStrategy(adaptiveBatchStrategy);
            if (!this.parameter.isDirectMode()) {
                reader.setTableEntry(((Optional)this.tableEntryMap.get(table)).orElse(null));
                reader.setTablePartLeaderMap(this.tablePartLeaderMap);
            }
            this.taskDetailList.add(tempSubFile.getTaskDetail());
            this.readerExecutor.submit(reader);
        }
        log.info("Start {} record file reader threads success", (Object)readerThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Record parseFirstRecord(SubFile subFile) {
        AbstractRecordParser recordParser = null;
        try {
            recordParser = subFile.createRecordParser(this.parameter);
            Iterator<Record> iter = recordParser.iterator();
            Record record = iter.hasNext() ? iter.next() : null;
            return record;
        }
        catch (Exception e) {
            log.warn("Ignore parse first record. File: \"{}\". Error: {}", (Object)subFile.getUniquePath(), (Object)ExceptionUtils.getRootCauseMessage(e));
            Record record = null;
            return record;
        }
        finally {
            if (recordParser != null) {
                AbstractRecordParser finalRecordParser = recordParser;
                CompletableFuture.runAsync(() -> {
                    try {
                        finalRecordParser.close();
                    }
                    catch (Exception e) {
                        log.warn("Close resource: \"{}\" failed. Error: {}", (Object)subFile.getResource().getResourcePath(), (Object)ExceptionUtils.getRootCauseMessage(e));
                    }
                });
            }
        }
    }
}

