/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.loader.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.oceanbase.tools.loaddump.base.State;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.ServerStatus;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.common.model.TaskDetail;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.concurrent.ExecutorTemplate;
import com.oceanbase.tools.loaddump.concurrent.ThreadPoolBuilder;
import com.oceanbase.tools.loaddump.context.TaskContext;
import com.oceanbase.tools.loaddump.loader.AbstractLoader;
import com.oceanbase.tools.loaddump.loader.ILoader;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemaFileLoader
extends AbstractLoader {
    private static final Logger log = LoggerFactory.getLogger(AbstractSchemaFileLoader.class);

    public AbstractSchemaFileLoader(LoadParameter parameter) {
        super(parameter);
    }

    @Override
    public ILoader prepare() throws Exception {
        ExecutorTemplate.setPoolSize(this.parameter.getThreads());
        List<SubFile> subFiles = this.generateSubFiles();
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(subFiles), (Object)"The -schema.sql files are not found.");
        this.parameter.setSubFiles(subFiles);
        String databaseName = this.parameter.getDatabaseName();
        ServerMode serverMode = this.parameter.getDatabase().getServerMode();
        String schemaName = DBUtils.extractObjectName(databaseName, serverMode);
        for (SubFile subFile : subFiles) {
            subFile.setSchemaName(schemaName);
            subFile.setTaskState(TaskState.INITIAL);
            subFile.setTaskDetail(new TaskDetail());
            this.taskDetailList.add(subFile.getTaskDetail());
        }
        super.setWriterExecutor(new ThreadPoolBuilder().setCorePoolSize(1).setMaximumPoolSize(1).setQueueSize(subFiles.size()).setThreadPrefixName("load-schema-thread-").build());
        this.state = State.PREPARE;
        return this;
    }

    @Override
    public TaskContext loadRecordAsync() throws Exception {
        throw new UnsupportedOperationException("Load record is unsupported");
    }

    @Override
    public ServerStatus getServerStatus() {
        return new ServerStatus(Maps.newHashMap());
    }

    @Override
    public boolean isThreadPoolAlive() {
        return this.isAlive(this.writerExecutor);
    }

    @Override
    public void shutdown() throws Exception {
        this.shutdownInternal(false, this.writerExecutor);
        this.supervisor.compareAndSet(true, false);
        this.state = State.TERMINATE;
    }

    @Override
    public void shutdownNow() throws Exception {
        this.supervisor.compareAndSet(true, false);
        this.shutdownInternal(true, this.writerExecutor);
        this.state = State.TERMINATE;
    }

    @Override
    public void stopLogReporter() {
        throw new UnsupportedOperationException("Not implemented!");
    }
}

