/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.log4j2.extension;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.logging.log4j.spi.ThreadContextMap;

public class TtlThreadContextMap
implements ThreadContextMap {
    private final ThreadLocal<Map<String, String>> tl = new TransmittableThreadLocal();

    public void put(String key, String value) {
        Map<String, String> map = this.tl.get();
        map = map == null ? new HashMap<String, String>() : new HashMap<String, String>(map);
        map.put(key, value);
        this.tl.set(Collections.unmodifiableMap(map));
    }

    public String get(String key) {
        Map<String, String> map = this.tl.get();
        return map == null ? null : map.get(key);
    }

    public void remove(String key) {
        Map<String, String> map = this.tl.get();
        if (map != null) {
            HashMap<String, String> copy = new HashMap<String, String>(map);
            copy.remove(key);
            this.tl.set(Collections.unmodifiableMap(copy));
        }
    }

    public void clear() {
        this.tl.remove();
    }

    public boolean containsKey(String key) {
        Map<String, String> map = this.tl.get();
        return map != null && map.containsKey(key);
    }

    public Map<String, String> getCopy() {
        Map<String, String> map = this.tl.get();
        return map == null ? new HashMap<String, String>() : new HashMap<String, String>(map);
    }

    public Map<String, String> getImmutableMapOrNull() {
        return this.tl.get();
    }

    public boolean isEmpty() {
        return MapUtils.isEmpty(this.tl.get());
    }

    public String toString() {
        Map<String, String> map = this.tl.get();
        return map == null ? "{}" : map.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        Map<String, String> map = this.tl.get();
        result = 31 * result + (map == null ? 0 : map.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TtlThreadContextMap)) {
            return false;
        }
        TtlThreadContextMap other = (TtlThreadContextMap)obj;
        Map<String, String> map = this.tl.get();
        Map<String, String> otherMap = other.getImmutableMapOrNull();
        return !(map == null ? otherMap != null : !map.equals(otherMap));
    }
}

