/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.manager;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.MapObject;
import com.oceanbase.tools.loaddump.function.context.ControlContext;
import com.oceanbase.tools.loaddump.function.context.ControlDescription;
import com.oceanbase.tools.loaddump.function.visitor.DefaultControlParserVisitor;
import com.oceanbase.tools.loaddump.parser.record.pos.Offset;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.LogUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ControlManager {
    private static final Logger log = LoggerFactory.getLogger(ControlManager.class);
    private final Map<String, Map<String, ControlContext>> schemaControlContextMap = new HashMap<String, Map<String, ControlContext>>();
    private final Map<String, Map<String, MapObject>> columnNameMapping = new HashMap<String, Map<String, MapObject>>();

    public static ControlManager parse(File ctlPath, String database, Set<String> tableSet, ServerMode serverMode) throws Exception {
        Collection controlFiles;
        ControlManager target = new ControlManager();
        if (ctlPath.isFile()) {
            controlFiles = Lists.newArrayList((Object[])new File[]{ctlPath});
            Preconditions.checkState((tableSet.size() == 1 ? 1 : 0) != 0, (Object)"A control file must correspond to one table. Please check the --table, --ctl-path options");
        } else {
            controlFiles = FileUtils.listFiles((File)ctlPath, (String[])new String[]{"ctrl"}, (boolean)true);
            if (CollectionUtils.isEmpty((Collection)controlFiles)) {
                LogUtils.warn("No control files were defined in the path: \"{}\"", ctlPath.getAbsolutePath());
                return target;
            }
        }
        String schemaName = DBUtils.extractObjectName(database, serverMode);
        List<String> tableNames = DBUtils.toCaseInsensitiveNamesList(serverMode, tableSet);
        ArrayList<String> withinCtrls = new ArrayList<String>(tableSet.size());
        boolean skipMatchCheck = CollectionUtils.isEmpty(tableNames) || tableNames.stream().anyMatch(t -> t.contains("*"));
        for (File controlFile : controlFiles) {
            String table;
            String controlFilePath = controlFile.getAbsolutePath();
            String controlFileName = DBUtils.extractObjectName(controlFile.getName(), serverMode);
            if (ctlPath.isFile()) {
                table = tableNames.get(0);
            } else {
                table = DBUtils.extractObjectName(FileUtils.getFileNameWithoutSuffix(controlFileName), serverMode);
                String tableIgnoreCase = DBUtils.extractObjectName(table, serverMode);
                if (!skipMatchCheck && !tableNames.contains(tableIgnoreCase)) {
                    LogUtils.info("The control file: \"{}\" is unexpected, ignore it", controlFilePath);
                    continue;
                }
            }
            ControlContext controlContext = DefaultControlParserVisitor.doParse(controlFile, serverMode);
            controlContext.setSchemaName(schemaName);
            controlContext.setTableName(table);
            List<String> columnNameList = controlContext.getColumnNameList();
            if (CollectionUtils.isEmpty(columnNameList)) {
                LogUtils.info("The control file: \"{}\" is invalid, ignore it", controlFilePath);
                continue;
            }
            LinkedHashMap singleTableMapping = new LinkedHashMap();
            columnNameList.stream().filter(c -> !c.equalsIgnoreCase("_FILLER")).forEach(c -> {
                ControlDescription description = controlContext.getControlDescriptionByColumnName((String)c);
                MapObject mapObj = new MapObject();
                if (description.getMappedIndex() != null) {
                    mapObj.setSource(description.getMappedIndex() - 1);
                }
                mapObj.setGeneratedDefine(description.getGeneratedDefine());
                singleTableMapping.put(c, mapObj);
            });
            target.columnNameMapping.put(table, singleTableMapping);
            target.schemaControlContextMap.computeIfAbsent(schemaName, v -> new HashMap()).put(table, controlContext);
            withinCtrls.add(controlContext.getTableName());
            LogUtils.info("Parse ctrl definition: \"{}\" success", controlFilePath);
        }
        withinCtrls.forEach(tableNames::remove);
        tableNames.forEach(t -> LogUtils.info("No valid control file was defined for the table: \"{}\"", t));
        return target;
    }

    private ControlManager() {
    }

    public static ControlManager newInstance() {
        return new ControlManager();
    }

    public synchronized void register(String schemaName, String tableName, ControlContext controlContext) {
        this.schemaControlContextMap.computeIfAbsent(schemaName, v -> new HashMap()).put(tableName, controlContext);
    }

    public ControlDescription getControl(String schemaName, String tableName, String columnName) {
        Map<String, ControlContext> map = this.schemaControlContextMap.get(schemaName);
        if (MapUtils.isEmpty(map) || map.get(tableName) == null) {
            return null;
        }
        return map.get(tableName).getControlDescriptionByColumnName(columnName);
    }

    public boolean isControlDefined(String schemaName, String tableName) {
        Map<String, ControlContext> map = this.schemaControlContextMap.get(schemaName);
        return MapUtils.isNotEmpty(map) && map.get(tableName) != null;
    }

    public List<Offset> getOffsets(String schemaName, String tableName) {
        Map<String, ControlContext> map = this.schemaControlContextMap.get(schemaName);
        Preconditions.checkArgument((MapUtils.isNotEmpty(map) && map.get(tableName) != null ? 1 : 0) != 0, (String)"The control context is null. Table: %s", (Object)tableName);
        return map.get(tableName).getOffsets();
    }

    public String transform(String schemaName, String tableName, String columnName, String value) throws Exception {
        ControlDescription description;
        if (this.isControlDefined(schemaName, tableName) && (description = this.getControl(schemaName, tableName, columnName)) != null) {
            return description.invoke(value);
        }
        return value;
    }

    public Map<String, Map<String, MapObject>> getColumnNameMapping() {
        return this.columnNameMapping;
    }
}

