/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.manager;

import com.oceanbase.tools.loaddump.utils.TimeUtils;
import com.oceanbase.tools.loaddump.vmoption.JavaOpts;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryManager {
    private static final Logger log = LoggerFactory.getLogger(MemoryManager.class);
    private static final float BLOCK_HEAP_MEM_THRESHOLD = 0.5f;
    private static final float RELEASE_HEAP_MEM_THRESHOLD = 0.3f;
    private static final long MAX_HEAP_MEMORY = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
    private static final long BLOCK_MEM_LIMIT = (long)((float)MAX_HEAP_MEMORY * 0.5f);
    private static final long RELEASE_MEM_LIMIT = (long)((float)MAX_HEAP_MEMORY * 0.3f);
    private final AtomicLong memAllocated = new AtomicLong(0L);
    private final ReentrantLock lock = new ReentrantLock();
    private final boolean disabled = JavaOpts.isDisableMemoryCheck;

    public void checkMemory(long byteSize) {
        if (this.disabled || this.memAllocated.addAndGet(byteSize) < BLOCK_MEM_LIMIT) {
            return;
        }
        this.lock.lock();
        try {
            log.debug("Memory limit exceeded: {}", (Object)Float.valueOf((float)this.memAllocated.get() * 1.0f / (float)BLOCK_MEM_LIMIT));
            while (this.memAllocated.get() > RELEASE_MEM_LIMIT) {
                TimeUtils.sleep(TimeUnit.MILLISECONDS, 50L);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void free(long byteSize) {
        if (this.disabled) {
            return;
        }
        this.memAllocated.addAndGet(-byteSize);
    }

    public AtomicLong getMemAllocated() {
        return this.memAllocated;
    }
}

