/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.metrics;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class EWMA {
    private static final int INTERVAL = 5;
    private static final double SECONDS_PER_MINUTE = 60.0;
    private static final int ONE_MINUTE = 1;
    private static final double M1_ALPHA = 1.0 - Math.exp(-0.08333333333333333);
    private final LongAdder uncounted = new LongAdder();
    private final double alpha;
    private final double interval;
    private volatile boolean initialized = false;
    private volatile double rate = 0.0;

    public EWMA(double alpha, long interval, TimeUnit intervalUnit) {
        this.interval = intervalUnit.toNanos(interval);
        this.alpha = alpha;
    }

    public static EWMA oneMinuteEWMA() {
        return new EWMA(M1_ALPHA, 5L, TimeUnit.SECONDS);
    }

    public void update(long n) {
        this.uncounted.add(n);
    }

    public void tick() {
        long count = this.uncounted.sumThenReset();
        double instantRate = (double)count / this.interval;
        if (this.initialized) {
            double oldRate = this.rate;
            this.rate = oldRate + this.alpha * (instantRate - oldRate);
        } else {
            this.rate = instantRate;
            this.initialized = true;
        }
    }

    public double getRate(TimeUnit rateUnit) {
        return this.rate * (double)rateUnit.toNanos(1L);
    }
}

