/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.mybatis.type;

import com.oceanbase.tools.loaddump.mybatis.type.ArrayTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.BigDecimalTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.BigIntegerTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.BlobByteObjectArrayTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.BlobInputStreamTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.BlobTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.BooleanTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.ByteArrayTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.ByteObjectArrayTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.ByteTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.CharacterTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.ClobReaderTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.ClobTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.DateOnlyTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.DateTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.EnumTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.InstantTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.IntegerTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.JapaneseDateTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.JdbcType;
import com.oceanbase.tools.loaddump.mybatis.type.LocalDateTimeTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.LocalDateTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.LocalTimeTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.LongTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.MonthTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.NClobTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.NStringTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.ObjectTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.OffsetDateTimeTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.OffsetTimeTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.ShortTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.SqlDateTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.SqlTimeTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.SqlTimestampTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.SqlXmlTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.StringTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.TimeOnlyTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.TypeException;
import com.oceanbase.tools.loaddump.mybatis.type.TypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.UnknownTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.YearMonthTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.ZonedDateTimeTypeHandler;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.JapaneseDate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypeHandlerRegistry
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(TypeHandlerRegistry.class);
    private static final long serialVersionUID = -3163863837970844882L;
    private static final TypeHandlerRegistry REGISTRY_INSTANCE = new TypeHandlerRegistry();
    private static final Map<JdbcType, TypeHandler<?>> NULL_TYPE_HANDLER_MAP = Collections.emptyMap();
    private final Map<JdbcType, TypeHandler<?>> jdbcTypeHandlerMap = new ConcurrentHashMap();
    private final Map<Type, Map<JdbcType, TypeHandler<?>>> typeHandlerMap = new ConcurrentHashMap();
    private final Map<Class<?>, TypeHandler<?>> allTypeHandlersMap = new ConcurrentHashMap();
    private final Class<? extends TypeHandler> defaultEnumTypeHandler = EnumTypeHandler.class;

    private TypeHandlerRegistry() {
        this.register(Boolean.class, new BooleanTypeHandler());
        this.register(Boolean.TYPE, new BooleanTypeHandler());
        this.register(JdbcType.BOOLEAN, new BooleanTypeHandler());
        this.register(JdbcType.BIT, new BooleanTypeHandler());
        this.register(Byte.class, new ByteTypeHandler());
        this.register(Byte.TYPE, new ByteTypeHandler());
        this.register(JdbcType.TINYINT, new ByteTypeHandler());
        this.register(Short.class, new ShortTypeHandler());
        this.register(Short.TYPE, new ShortTypeHandler());
        this.register(JdbcType.SMALLINT, new ShortTypeHandler());
        this.register(Integer.class, new IntegerTypeHandler());
        this.register(Integer.TYPE, new IntegerTypeHandler());
        this.register(JdbcType.INTEGER, new IntegerTypeHandler());
        this.register(Long.class, new LongTypeHandler());
        this.register(Long.TYPE, new LongTypeHandler());
        this.register((Type)((Object)Double.class), (TypeHandler)new BigDecimalTypeHandler());
        this.register((Type)Double.TYPE, (TypeHandler)new BigDecimalTypeHandler());
        this.register(JdbcType.DOUBLE, new BigDecimalTypeHandler());
        this.register(Reader.class, new ClobReaderTypeHandler());
        this.register(String.class, new StringTypeHandler());
        this.register(String.class, JdbcType.CHAR, new StringTypeHandler());
        this.register(String.class, JdbcType.NCHAR, new NStringTypeHandler());
        this.register(String.class, JdbcType.VARCHAR, new StringTypeHandler());
        this.register(String.class, JdbcType.NVARCHAR, new NStringTypeHandler());
        this.register(String.class, JdbcType.LONGVARCHAR, new StringTypeHandler());
        this.register(String.class, JdbcType.CLOB, new ClobTypeHandler());
        this.register(String.class, JdbcType.NCLOB, new NClobTypeHandler());
        this.register(JdbcType.CHAR, new StringTypeHandler());
        this.register(JdbcType.VARCHAR, new StringTypeHandler());
        this.register(JdbcType.LONGVARCHAR, new StringTypeHandler());
        this.register(JdbcType.NCHAR, new NStringTypeHandler());
        this.register(JdbcType.NVARCHAR, new NStringTypeHandler());
        this.register(JdbcType.CLOB, new ClobTypeHandler());
        this.register(JdbcType.NCLOB, new NClobTypeHandler());
        this.register(Object.class, JdbcType.ARRAY, new ArrayTypeHandler());
        this.register(JdbcType.ARRAY, new ArrayTypeHandler());
        this.register(BigInteger.class, new BigIntegerTypeHandler());
        this.register(JdbcType.BIGINT, new LongTypeHandler());
        this.register((Type)((Object)BigDecimal.class), (TypeHandler)new BigDecimalTypeHandler());
        this.register(JdbcType.REAL, new BigDecimalTypeHandler());
        this.register(JdbcType.DECIMAL, new BigDecimalTypeHandler());
        this.register(JdbcType.NUMBER, new BigDecimalTypeHandler());
        this.register(JdbcType.NUMERIC, new BigDecimalTypeHandler());
        this.register(InputStream.class, new BlobInputStreamTypeHandler());
        this.register(Byte[].class, new ByteObjectArrayTypeHandler());
        this.register(Byte[].class, JdbcType.BLOB, new BlobByteObjectArrayTypeHandler());
        this.register(Byte[].class, JdbcType.LONGVARBINARY, new BlobByteObjectArrayTypeHandler());
        this.register(byte[].class, new ByteArrayTypeHandler());
        this.register(byte[].class, JdbcType.BLOB, new BlobTypeHandler());
        this.register(byte[].class, JdbcType.LONGVARBINARY, new BlobTypeHandler());
        this.register(JdbcType.BLOB, new BlobTypeHandler());
        this.register(JdbcType.LONGVARBINARY, new BlobTypeHandler());
        this.register(Object.class, new UnknownTypeHandler(this));
        this.register(JdbcType.OTHER, new UnknownTypeHandler(this));
        this.register(Object.class, JdbcType.OTHER, new UnknownTypeHandler(this));
        this.register(java.util.Date.class, new DateTypeHandler());
        this.register(java.util.Date.class, JdbcType.DATE, new DateOnlyTypeHandler());
        this.register(java.util.Date.class, JdbcType.TIME, new TimeOnlyTypeHandler());
        this.register(JdbcType.DATE, new DateOnlyTypeHandler());
        this.register(JdbcType.TIME, new TimeOnlyTypeHandler());
        this.register(JdbcType.TIMESTAMP, new DateTypeHandler());
        this.register(Date.class, new SqlDateTypeHandler());
        this.register(Time.class, new SqlTimeTypeHandler());
        this.register((Type)((Object)Timestamp.class), (TypeHandler)new SqlTimestampTypeHandler());
        this.register(String.class, JdbcType.SQLXML, new SqlXmlTypeHandler());
        this.register(Instant.class, new InstantTypeHandler());
        this.register(LocalDate.class, new LocalDateTypeHandler());
        this.register(LocalTime.class, new LocalTimeTypeHandler());
        this.register(OffsetTime.class, new OffsetTimeTypeHandler());
        this.register(LocalDateTime.class, new LocalDateTimeTypeHandler());
        this.register(OffsetDateTime.class, new OffsetDateTimeTypeHandler());
        this.register(ZonedDateTime.class, new ZonedDateTimeTypeHandler());
        this.register(Month.class, new MonthTypeHandler());
        this.register(YearMonth.class, new YearMonthTypeHandler());
        this.register(JapaneseDate.class, new JapaneseDateTypeHandler());
        this.register(Character.TYPE, new CharacterTypeHandler());
        this.register(Character.class, new CharacterTypeHandler());
    }

    public static TypeHandlerRegistry getInstance() {
        return REGISTRY_INSTANCE;
    }

    public TypeHandler<?> getTypeHandler(@NonNull JdbcType jdbcType) {
        if (jdbcType == null) {
            throw new NullPointerException("jdbcType is marked non-null but is null");
        }
        TypeHandler<?> typeHandler = this.jdbcTypeHandlerMap.get((Object)jdbcType);
        if (typeHandler == null) {
            log.warn("No available type handler was found for the jdbc type: {}", (Object)jdbcType);
            return new ObjectTypeHandler();
        }
        return typeHandler;
    }

    public <T> TypeHandler<T> getTypeHandler(Class<T> type) {
        return this.getTypeHandler(type, null);
    }

    private <T> TypeHandler<T> getTypeHandler(Type type, JdbcType jdbcType) {
        Map<JdbcType, TypeHandler<?>> jdbcHandlerMap = this.getJdbcHandlerMap(type);
        TypeHandler<?> handler = null;
        if (jdbcHandlerMap != null) {
            handler = jdbcHandlerMap.get((Object)jdbcType);
            if (handler == null) {
                handler = jdbcHandlerMap.get(null);
            }
            if (handler == null) {
                handler = this.pickSoleHandler(jdbcHandlerMap);
            }
        }
        return handler;
    }

    private Map<JdbcType, TypeHandler<?>> getJdbcHandlerMap(Type type) {
        Map<JdbcType, TypeHandler<?>> jdbcHandlerMap = this.typeHandlerMap.get(type);
        if (NULL_TYPE_HANDLER_MAP.equals(jdbcHandlerMap)) {
            return null;
        }
        if (jdbcHandlerMap == null && type instanceof Class) {
            Class clazz = (Class)type;
            if (Enum.class.isAssignableFrom(clazz)) {
                Class enumClass = clazz.isAnonymousClass() ? clazz.getSuperclass() : clazz;
                jdbcHandlerMap = this.getJdbcHandlerMapForEnumInterfaces(enumClass, enumClass);
                if (jdbcHandlerMap == null) {
                    this.register(enumClass, this.getInstance(enumClass, this.defaultEnumTypeHandler));
                    return this.typeHandlerMap.get(enumClass);
                }
            } else {
                jdbcHandlerMap = this.getJdbcHandlerMapForSuperclass(clazz);
            }
        }
        this.typeHandlerMap.put(type, jdbcHandlerMap == null ? NULL_TYPE_HANDLER_MAP : jdbcHandlerMap);
        return jdbcHandlerMap;
    }

    private Map<JdbcType, TypeHandler<?>> getJdbcHandlerMapForEnumInterfaces(Class<?> clazz, Class<?> enumClazz) {
        for (Class<?> iface : clazz.getInterfaces()) {
            Map<JdbcType, TypeHandler<?>> jdbcHandlerMap = this.typeHandlerMap.get(iface);
            if (jdbcHandlerMap == null) {
                jdbcHandlerMap = this.getJdbcHandlerMapForEnumInterfaces(iface, enumClazz);
            }
            if (jdbcHandlerMap == null) continue;
            HashMap newMap = new HashMap();
            for (Map.Entry<JdbcType, TypeHandler<?>> entry : jdbcHandlerMap.entrySet()) {
                newMap.put(entry.getKey(), this.getInstance(enumClazz, entry.getValue().getClass()));
            }
            return newMap;
        }
        return null;
    }

    private Map<JdbcType, TypeHandler<?>> getJdbcHandlerMapForSuperclass(Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass == null || Object.class.equals(superclass)) {
            return null;
        }
        Map<JdbcType, TypeHandler<?>> jdbcHandlerMap = this.typeHandlerMap.get(superclass);
        if (jdbcHandlerMap != null) {
            return jdbcHandlerMap;
        }
        return this.getJdbcHandlerMapForSuperclass(superclass);
    }

    private TypeHandler<?> pickSoleHandler(Map<JdbcType, TypeHandler<?>> jdbcHandlerMap) {
        TypeHandler<?> soleHandler = null;
        for (TypeHandler<?> handler : jdbcHandlerMap.values()) {
            if (soleHandler == null) {
                soleHandler = handler;
                continue;
            }
            if (handler.getClass().equals(soleHandler.getClass())) continue;
            return null;
        }
        return soleHandler;
    }

    public void register(JdbcType jdbcType, TypeHandler<?> handler) {
        this.jdbcTypeHandlerMap.put(jdbcType, handler);
    }

    public <T> void register(Class<T> javaType, TypeHandler<? extends T> typeHandler) {
        this.register(javaType, null, typeHandler);
    }

    private <T> void register(Type javaType, TypeHandler<? extends T> typeHandler) {
        this.register(javaType, null, typeHandler);
    }

    public <T> void register(Class<T> type, JdbcType jdbcType, TypeHandler<? extends T> handler) {
        this.register((Type)type, jdbcType, (TypeHandler<?>)handler);
    }

    private void register(Type javaType, JdbcType jdbcType, TypeHandler<?> handler) {
        if (javaType != null) {
            Map<JdbcType, TypeHandler<?>> map = this.typeHandlerMap.get(javaType);
            if (map == null || map == NULL_TYPE_HANDLER_MAP) {
                map = new HashMap();
                this.typeHandlerMap.put(javaType, map);
            }
            map.put(jdbcType, handler);
        }
        this.allTypeHandlersMap.put(handler.getClass(), handler);
    }

    public <T> TypeHandler<T> getInstance(Class<?> javaTypeClass, Class<?> typeHandlerClass) {
        if (javaTypeClass != null) {
            try {
                Constructor<?> c = typeHandlerClass.getConstructor(Class.class);
                return (TypeHandler)c.newInstance(javaTypeClass);
            }
            catch (NoSuchMethodException c) {
            }
            catch (Exception e) {
                throw new TypeException("Failed invoking constructor for handler " + typeHandlerClass, e);
            }
        }
        try {
            Constructor<?> c = typeHandlerClass.getConstructor(new Class[0]);
            return (TypeHandler)c.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new TypeException("Unable to find a usable constructor for " + typeHandlerClass, e);
        }
    }
}

