/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.mybatis.type;

import com.oceanbase.tools.loaddump.mybatis.type.BaseTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.JdbcType;
import com.oceanbase.tools.loaddump.mybatis.type.ObjectTypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.TypeException;
import com.oceanbase.tools.loaddump.mybatis.type.TypeHandler;
import com.oceanbase.tools.loaddump.mybatis.type.TypeHandlerRegistry;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;

public class UnknownTypeHandler
extends BaseTypeHandler<Object> {
    private static final long serialVersionUID = 2991135593847957311L;
    private static final ObjectTypeHandler OBJECT_TYPE_HANDLER = new ObjectTypeHandler();
    private TypeHandlerRegistry typeHandlerRegistry;

    public UnknownTypeHandler() {
    }

    public UnknownTypeHandler(TypeHandlerRegistry typeHandlerRegistry) {
        this.typeHandlerRegistry = typeHandlerRegistry;
    }

    @Override
    public Object getNullableResult(ResultSet rs, String columnName) throws SQLException {
        TypeHandler<?> handler = this.resolveTypeHandler(rs, columnName);
        return handler.getResult(rs, columnName);
    }

    @Override
    public Object getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        ObjectTypeHandler handler = this.resolveTypeHandler(rs.getMetaData(), columnIndex);
        if (handler == null || handler instanceof UnknownTypeHandler) {
            handler = OBJECT_TYPE_HANDLER;
        }
        return handler.getResult(rs, columnIndex);
    }

    private TypeHandler<?> resolveTypeHandler(ResultSetMetaData rsmd, Integer columnIndex) {
        JdbcType jdbcType = this.safeGetJdbcTypeForColumn(rsmd, columnIndex);
        return this.typeHandlerRegistry.getTypeHandler(jdbcType);
    }

    private TypeHandler<?> resolveTypeHandler(ResultSet rs, String column) {
        try {
            HashMap<String, Integer> columnIndexLookup = new HashMap<String, Integer>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int count = rsmd.getColumnCount();
            for (int i = 1; i <= count; ++i) {
                String name = rsmd.getColumnName(i);
                columnIndexLookup.put(name, i);
            }
            Integer columnIndex = (Integer)columnIndexLookup.get(column);
            TypeHandler<Object> handler = null;
            if (columnIndex != null) {
                handler = this.resolveTypeHandler(rsmd, columnIndex);
            }
            if (handler == null || handler instanceof UnknownTypeHandler) {
                handler = OBJECT_TYPE_HANDLER;
            }
            return handler;
        }
        catch (SQLException e) {
            throw new TypeException("Error determining JDBC type for column " + column + ".  Cause: " + e, e);
        }
    }

    private JdbcType safeGetJdbcTypeForColumn(ResultSetMetaData rsmd, Integer columnIndex) {
        try {
            JdbcType jdbcType = JdbcType.forCode(rsmd.getColumnType(columnIndex));
            return jdbcType.toString().equalsIgnoreCase(JdbcType.NULL.toString()) ? JdbcType.OTHER : jdbcType;
        }
        catch (Exception e) {
            return JdbcType.VARCHAR;
        }
    }

    public TypeHandlerRegistry getTypeHandlerRegistry() {
        return this.typeHandlerRegistry;
    }

    public void setTypeHandlerRegistry(TypeHandlerRegistry typeHandlerRegistry) {
        this.typeHandlerRegistry = typeHandlerRegistry;
    }
}

