/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.mybatis.type.custom;

import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.mybatis.type.custom.AbstractToStringTypeHandler;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;

public class DateToStringTypeHandler
extends AbstractToStringTypeHandler {
    private static final long serialVersionUID = -8700043915957152795L;
    private static final String DEFAULT_ZERO_DATE_VALUE = "0000-00-00";
    private final boolean mysqlMode;
    private DateTimeFormatter dateValueFormatter;
    private boolean preserveZeroDatetime;

    public DateToStringTypeHandler(boolean isMySqlMode) {
        this(null, isMySqlMode, false);
    }

    public DateToStringTypeHandler(String dateValuePattern, boolean isMySqlMode, boolean preserveZeroDatetime) {
        this.mysqlMode = isMySqlMode;
        this.preserveZeroDatetime = preserveZeroDatetime;
        if (StringUtils.isNotBlank(dateValuePattern)) {
            this.dateValueFormatter = DateTimeFormatter.ofPattern(dateValuePattern);
        }
    }

    @Override
    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.mysqlMode ? this.translateTo(rs.getDate(columnName)) : this.translateTo(rs.getTimestamp(columnName));
    }

    @Override
    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.mysqlMode ? this.translateTo(rs.getDate(columnIndex)) : this.translateTo(rs.getTimestamp(columnIndex));
    }

    @Override
    public String getResult(ResultSet rs, int columnIndex) throws SQLException {
        String result = this.getNullableResult(rs, columnIndex);
        if (result == null && rs.getMetaData().isNullable(columnIndex) == 0) {
            return this.preserveZeroDatetime && this.isMysqlMode() ? DEFAULT_ZERO_DATE_VALUE : null;
        }
        return result;
    }

    @Override
    public String getResult(ResultSet rs, String columnName) throws SQLException {
        int columnIndex;
        int columnCount = rs.getMetaData().getColumnCount();
        for (columnIndex = 1; columnIndex <= columnCount && !rs.getMetaData().getColumnName(columnIndex).equals(columnName); ++columnIndex) {
        }
        return this.getResult(rs, columnIndex);
    }

    private String translateTo(Object obj) {
        Comparable<ChronoLocalDate> temporal;
        if (obj == null) {
            return null;
        }
        Comparable<ChronoLocalDate> comparable = temporal = this.mysqlMode ? ((Date)obj).toLocalDate() : ((Timestamp)obj).toLocalDateTime();
        if (this.dateValueFormatter != null) {
            return this.dateValueFormatter.format((TemporalAccessor)((Object)temporal));
        }
        return this.mysqlMode ? Constants.DEFAULT_MYSQL_DATE_FORMATTER.format((TemporalAccessor)((Object)temporal)) : Constants.DEFAULT_ORACLE_DATE_FORMATTER.format((TemporalAccessor)((Object)temporal));
    }

    public boolean isMysqlMode() {
        return this.mysqlMode;
    }
}

