/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.mybatis.type.custom;

import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.mybatis.type.custom.AbstractToStringTypeHandler;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class TimestampToStringTypeHandler
extends AbstractToStringTypeHandler {
    private static final long serialVersionUID = -1409710425258750642L;
    private static final String DEFAULT_ZERO_TIMESTAMP_VALUE = "0000-00-00 00:00:00";
    private final boolean mysqlMode;
    private int precision;
    private DateTimeFormatter timestampValueFormatter;
    private boolean preserveZeroDatetime;

    public TimestampToStringTypeHandler(boolean isMySqlMode, String timestampValuePattern, int precision, boolean preserveZeroDatetime) {
        this.mysqlMode = isMySqlMode;
        this.precision = precision;
        this.preserveZeroDatetime = preserveZeroDatetime;
        if (StringUtils.isNotBlank(timestampValuePattern)) {
            this.timestampValueFormatter = DateTimeFormatter.ofPattern(timestampValuePattern);
        }
    }

    @Override
    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.translateTo(rs.getTimestamp(columnIndex));
    }

    @Override
    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.translateTo(rs.getTimestamp(columnName));
    }

    @Override
    public String getResult(ResultSet rs, int columnIndex) throws SQLException {
        String result = this.getNullableResult(rs, columnIndex);
        if (result == null && rs.getMetaData().isNullable(columnIndex) == 0) {
            return this.preserveZeroDatetime && this.isMysqlMode() ? DEFAULT_ZERO_TIMESTAMP_VALUE : null;
        }
        return result;
    }

    @Override
    public String getResult(ResultSet rs, String columnName) throws SQLException {
        int columnIndex;
        int columnCount = rs.getMetaData().getColumnCount();
        for (columnIndex = 1; columnIndex <= columnCount && !rs.getMetaData().getColumnName(columnIndex).equals(columnName); ++columnIndex) {
        }
        return this.getResult(rs, columnIndex);
    }

    private String translateTo(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        LocalDateTime ldt = timestamp.toLocalDateTime();
        return this.timestampValueFormatter == null ? this.localTimestampToString(ldt) : this.timestampValueFormatter.format(ldt);
    }

    private String localTimestampToString(LocalDateTime ldt) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(Constants.DEFAULT_TIMESTAMP_FORMATTER.format(ldt));
        if (this.precision == 0) {
            return sb.toString();
        }
        String nanoStr = super.formatNanoTime(ldt.getNano());
        sb.append('.').append(nanoStr);
        for (int i = this.precision - nanoStr.length(); i > 0; --i) {
            sb.append('0');
        }
        return sb.toString();
    }

    public boolean isMysqlMode() {
        return this.mysqlMode;
    }
}

