/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.object.pool;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.object.pool.LargeObjectPool;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicListPool
extends LargeObjectPool<List<String>> {
    private static final Logger log = LoggerFactory.getLogger(DynamicListPool.class);
    final ThreadLocal<List<String>> threadLocal = this.createThreadLocal();

    @Override
    public List<String> getObject(int capacity) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"Invalid array length");
        List<String> list = this.threadLocal.get();
        for (int i = 0; i < capacity; ++i) {
            list.add(null);
        }
        return list;
    }

    @Override
    protected ThreadLocal<List<String>> createThreadLocal() {
        return new ThreadLocal<List<String>>(){

            @Override
            protected List<String> initialValue() {
                return new ArrayList<String>();
            }

            @Override
            public List<String> get() {
                List list = (List)super.get();
                list.clear();
                return list;
            }
        };
    }
}

