/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class Record
implements Serializable {
    private static final long serialVersionUID = 3125441062003682173L;
    protected boolean parsed;
    protected String originContent;
    protected String badCause;
    private long characterPosition;
    private List<String> values;

    public Record(String origin, List<String> values, String badCause) {
        this.parsed = false;
        this.badCause = badCause;
        this.values = values;
        this.originContent = origin;
    }

    public Record(String sql, long characterPosition) {
        this.parsed = true;
        this.originContent = sql;
        this.characterPosition = characterPosition;
    }

    public Record(String[] values) {
        this.parsed = true;
        this.values = values != null ? Lists.newArrayList((Object[])values) : new ArrayList();
    }

    public Record(List<String> values, long characterPosition) {
        this.parsed = true;
        this.characterPosition = characterPosition;
        this.values = values != null ? values : new ArrayList(0);
    }

    public int size() {
        return this.isValid() ? this.values.size() : 0;
    }

    public String get(int index) {
        return this.isValid() ? this.values.get(index) : null;
    }

    public boolean isValid() {
        return this.parsed && CollectionUtils.isNotEmpty(this.values);
    }

    public void add(String value) {
        this.values.add(value);
    }

    public void replaceAll(List<String> values) {
        this.values.clear();
        this.values.addAll(values);
    }

    public void replace(int index, String replacer) {
        this.values.set(index, replacer);
    }

    public void remove(int index) {
        this.values.remove(index);
    }

    public List<String> getValues(Collection<Integer> indexes) {
        return indexes.stream().map(this::get).collect(Collectors.toList());
    }

    public void clearAll() {
        if (this.values != null) {
            this.values.clear();
            this.values = null;
        }
    }

    public String toString() {
        return CollectionUtils.isNotEmpty(this.getValues()) ? String.join((CharSequence)",", this.getValues()) : "Null Record";
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public void setParsed(boolean parsed) {
        this.parsed = parsed;
    }

    public String getOriginContent() {
        return this.originContent;
    }

    public void setOriginContent(String originContent) {
        this.originContent = originContent;
    }

    public String getBadCause() {
        return this.badCause;
    }

    public void setBadCause(String badCause) {
        this.badCause = badCause;
    }

    public long getCharacterPosition() {
        return this.characterPosition;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }
}

