/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.orc;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.parser.record.AbstractColumnOrientedParser;
import com.oceanbase.tools.loaddump.parser.record.Record;
import java.io.IOException;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DateColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;

public class OrcRecordParserV2
extends AbstractColumnOrientedParser {
    private final Reader reader;
    private final RecordReader recordReader;
    private final VectorizedRowBatch batch;
    private ColumnValueGetter[] columnValueGetters;
    private final ColumnStatistics[] columnStatistics;
    private int rowIndex = 0;

    private OrcRecordParserV2(Reader reader, RecordReader recordReader, TypeDescription schema, ColumnStatistics[] columnStatistics) {
        this.reader = reader;
        this.recordReader = recordReader;
        this.columnStatistics = columnStatistics;
        this.initColumnHandlerMap(schema);
        this.batch = schema.createRowBatchV2();
    }

    public static OrcRecordParserV2 parse(URI uri, Configuration conf) throws Exception {
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"Input uri is null");
        return new Builder().withUri(uri).withConf(conf).build();
    }

    public static OrcRecordParserV2 parse(String path, Configuration conf) throws Exception {
        return OrcRecordParserV2.parse(new URI(path), conf);
    }

    @Override
    public Record extractRecord() throws IOException {
        if (!(this.batch.size != 0 && this.rowIndex != this.batch.size || this.fetchNextBatch())) {
            return null;
        }
        int curIdx = this.rowIndex++;
        int colNum = this.columnValueGetters.length;
        String[] values = new String[colNum];
        Stream.iterate(0, i -> i + 1).limit(colNum).forEach(i -> {
            values[i.intValue()] = this.columnValueGetters[i].getValue(this.batch.cols[i], curIdx);
        });
        return new Record(values);
    }

    private boolean fetchNextBatch() throws IOException {
        this.rowIndex = 0;
        this.batch.reset();
        return this.recordReader.nextBatch(this.batch);
    }

    private void initColumnHandlerMap(TypeDescription schema) {
        int colNum = schema.getChildren().size();
        this.columnValueGetters = new ColumnValueGetter[colNum];
        block7: for (int i = 0; i < colNum; ++i) {
            TypeDescription type = (TypeDescription)schema.getChildren().get(i);
            boolean hasNull = this.columnStatistics[i + 1].hasNull();
            switch (type.getCategory()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: {
                    if (hasNull) {
                        this.columnValueGetters[i] = (vec, rowIdx) -> vec.isNull[rowIdx] ? null : String.valueOf(((LongColumnVector)vec).vector[rowIdx]);
                        continue block7;
                    }
                    this.columnValueGetters[i] = (vec, rowIdx) -> String.valueOf(((LongColumnVector)vec).vector[rowIdx]);
                    continue block7;
                }
                case FLOAT: 
                case DOUBLE: {
                    if (hasNull) {
                        this.columnValueGetters[i] = (vec, rowIdx) -> vec.isNull[rowIdx] ? null : String.valueOf(((DoubleColumnVector)vec).vector[rowIdx]);
                        continue block7;
                    }
                    this.columnValueGetters[i] = (vec, rowIdx) -> String.valueOf(((DoubleColumnVector)vec).vector[rowIdx]);
                    continue block7;
                }
                case DECIMAL: {
                    if (hasNull) {
                        this.columnValueGetters[i] = (vec, rowIdx) -> vec.isNull[rowIdx] ? null : String.valueOf(((DecimalColumnVector)vec).vector[rowIdx]);
                        continue block7;
                    }
                    this.columnValueGetters[i] = (vec, rowIdx) -> String.valueOf(((DecimalColumnVector)vec).vector[rowIdx]);
                    continue block7;
                }
                case DATE: {
                    int finalI = i;
                    if (hasNull) {
                        this.columnValueGetters[i] = (vec, rowIdx) -> vec.isNull[rowIdx] ? null : ((DateColumnVector)vec).formatDate(finalI);
                        continue block7;
                    }
                    this.columnValueGetters[i] = (vec, rowIdx) -> ((DateColumnVector)vec).formatDate(finalI);
                    continue block7;
                }
                case TIMESTAMP: {
                    if (hasNull) {
                        this.columnValueGetters[i] = (vec, rowIdx) -> {
                            if (vec.isNull[rowIdx]) {
                                return null;
                            }
                            long time = ((TimestampColumnVector)vec).getTime(rowIdx) / 1000L;
                            int nanos = ((TimestampColumnVector)vec).getNanos(rowIdx);
                            return LocalDateTime.ofEpochSecond(time, nanos, ZoneOffset.UTC).toString();
                        };
                        continue block7;
                    }
                    this.columnValueGetters[i] = (vec, rowIdx) -> {
                        if (vec.isNull[rowIdx]) {
                            return null;
                        }
                        long time = ((TimestampColumnVector)vec).getTime(rowIdx) / 1000L;
                        int nanos = ((TimestampColumnVector)vec).getNanos(rowIdx);
                        return LocalDateTime.ofEpochSecond(time, nanos, ZoneOffset.UTC).toString();
                    };
                    continue block7;
                }
                default: {
                    this.columnValueGetters[i] = hasNull ? (vec, rowIdx) -> vec.isNull[rowIdx] ? null : String.valueOf(((BytesColumnVector)vec).toString(rowIdx)) : (vec, rowIdx) -> String.valueOf(((BytesColumnVector)vec).toString(rowIdx));
                }
            }
        }
    }

    @Override
    public void close() throws Exception {
        if (this.batch != null) {
            this.batch.reset();
        }
        if (this.recordReader != null) {
            this.recordReader.close();
            this.closed = true;
        }
        if (this.reader != null) {
            this.reader.close();
        }
        super.close();
    }

    public static class Builder {
        private URI uri;
        private Configuration conf = new Configuration();

        public Builder withUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder withConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public OrcRecordParserV2 build() throws IOException {
            Preconditions.checkArgument((this.uri != null ? 1 : 0) != 0, (Object)"Input uri is null");
            this.conf.setBoolean(OrcConf.SKIP_CORRUPT_DATA.getAttribute(), false);
            OrcFile.ReaderOptions options = new OrcFile.ReaderOptions(this.conf);
            Reader reader = OrcFile.createReader((Path)new Path(this.uri), (OrcFile.ReaderOptions)options);
            TypeDescription schema = reader.getSchema();
            ColumnStatistics[] columnStatistics = reader.getStatistics();
            return new OrcRecordParserV2(reader, reader.rows(reader.options().schema(schema)), schema, columnStatistics);
        }
    }

    static interface ColumnValueGetter {
        public String getValue(ColumnVector var1, int var2);
    }
}

