/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.pos;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.parser.record.AbstractRowOrientedParser;
import com.oceanbase.tools.loaddump.parser.record.Record;
import com.oceanbase.tools.loaddump.parser.record.pos.Offset;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class PosRecordParser
extends AbstractRowOrientedParser {
    private final String charset;
    private final int length;
    private final List<Offset> offsets;
    private final InputStream stream;
    private final String lineSep;
    private final byte[] fieldBuffer;

    private PosRecordParser(InputStream stream, String charset, String lineSep, List<Offset> offsets) {
        this.stream = stream;
        this.charset = charset;
        this.offsets = offsets;
        this.lineSep = lineSep;
        Offset sampleOffset = offsets.get(offsets.size() - 1);
        this.length = sampleOffset.getType() == Offset.OffsetType.ABSOLUTE ? sampleOffset.getEndIndex() : offsets.stream().mapToInt(Offset::getRelLen).sum();
        this.fieldBuffer = new byte[this.length];
    }

    public static PosRecordParser parse(File file, String charset, String lineSep, List<Offset> offsets) throws IOException {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"Input file is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(offsets), (Object)"Input offsets is null");
        return new PosRecordParser(Files.newInputStream(file.toPath(), new OpenOption[0]), charset, lineSep, offsets);
    }

    public static PosRecordParser parse(InputStream stream, String charset, String lineSep, List<Offset> offsets) throws IOException {
        Preconditions.checkArgument((stream != null ? 1 : 0) != 0, (Object)"Input stream is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(offsets), (Object)"Input offsets is null");
        return new PosRecordParser(stream, charset, lineSep, offsets);
    }

    public static PosRecordParser parse(Path path, String charset, String lineSep, List<Offset> offsets) throws IOException {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"Input path is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(offsets), (Object)"Input offsets is null");
        return PosRecordParser.parse(Files.newInputStream(path, new OpenOption[0]), charset, lineSep, offsets);
    }

    public static PosRecordParser parse(URL url, String charset, String lineSep, List<Offset> offsets) throws IOException {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Input url is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(offsets), (Object)"Input offsets is null");
        return new PosRecordParser(url.openStream(), charset, lineSep, offsets);
    }

    @Override
    public Record nextRecord() throws IOException {
        byte[] src = new byte[this.length];
        try {
            int available = this.stream.read(src);
            if (available < 0) {
                return null;
            }
            if (available < this.length) {
                byte[] dest = new byte[available];
                System.arraycopy(src, 0, dest, 0, available);
                src = dest;
            }
            int size = this.offsets.size();
            ArrayList<String> values = new ArrayList<String>(size);
            int lastPos = 0;
            for (Offset offset : this.offsets) {
                if (offset == null) continue;
                if (offset.isFiller()) {
                    lastPos = offset.getType() == Offset.OffsetType.ABSOLUTE ? offset.getEndIndex() : lastPos + offset.getRelLen();
                    continue;
                }
                byte[] dest = new byte[offset.getLength()];
                if (offset.getType() == Offset.OffsetType.ABSOLUTE) {
                    System.arraycopy(src, offset.getBeginIndex() - 1, dest, 0, dest.length);
                } else {
                    System.arraycopy(src, lastPos, dest, 0, dest.length);
                    lastPos += offset.getRelLen();
                }
                values.add(new String(dest, this.charset));
            }
            this.stream.skip(this.lineSep.length());
            return new Record(values, 1L);
        }
        catch (Exception e) {
            return new Record(new String(src, this.charset), new ArrayList<String>(), e.getMessage());
        }
    }

    @Override
    public void close() throws Exception {
        if (this.stream != null) {
            this.stream.close();
            this.closed = true;
        }
        super.close();
    }

    public String getCharset() {
        return this.charset;
    }

    public int getLength() {
        return this.length;
    }

    public List<Offset> getOffsets() {
        return this.offsets;
    }

    public InputStream getStream() {
        return this.stream;
    }
}

