/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.sql;

import com.oceanbase.tools.loaddump.parser.record.ExtendedBufferedReader;
import com.oceanbase.tools.loaddump.parser.record.Token;
import com.oceanbase.tools.loaddump.utils.CharUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.IOException;
import java.util.regex.Pattern;

public class SqlLexer
implements AutoCloseable {
    private static final String SEMICOLON_CHAR = ";";
    private static final String CR_STRING = Character.toString('\r');
    private static final String LF_STRING = Character.toString('\n');
    private static final String IRRELEVANT_STMT_REGEX = "(^\\s*(begin|commit){1}\\s*;?\\s*)|(^\\s*(delimiter){1}\\s+(\\w|\\W)+\\s*)|(^\\s*(set){1}\\s+\\w+\\s+(on|off|(\\s*=\\s*\\d+)){1}\\s*;?\\s*)|(^\\s*(rem|spool|prompt){1}\\s*(\\w|\\W)*\\s*;?\\s*)";
    private static final Pattern FILTER_PATTERN = Pattern.compile("(^\\s*(begin|commit){1}\\s*;?\\s*)|(^\\s*(delimiter){1}\\s+(\\w|\\W)+\\s*)|(^\\s*(set){1}\\s+\\w+\\s+(on|off|(\\s*=\\s*\\d+)){1}\\s*;?\\s*)|(^\\s*(rem|spool|prompt){1}\\s*(\\w|\\W)*\\s*;?\\s*)", 2);
    private String firstEol;
    private String delimiter = ";";
    private ExtendedBufferedReader reader;

    public SqlLexer(ExtendedBufferedReader reader) {
        this.reader = reader;
    }

    public Token nextToken(Token token) throws IOException {
        int lastChar = this.reader.getLastChar();
        int ch = this.reader.read();
        boolean eol = this.isEndOfLine(ch);
        while (eol && this.isStartOfLine(lastChar)) {
            lastChar = ch;
            ch = this.reader.read();
            eol = this.isEndOfLine(ch);
            if (!this.isEndOfFile(ch)) continue;
            token.type = Token.Type.EOF;
            return token;
        }
        if (this.isEndOfStmt(ch)) {
            token.type = Token.Type.TOKEN;
            return token;
        }
        if (this.isEndOfFile(ch) || this.isEndOfFile(lastChar)) {
            token.type = Token.Type.EOF;
            return token;
        }
        while (true) {
            block20: {
                if (this.isQuoteChar(ch)) {
                    token.markQuote(ch);
                    token.content.append((char)ch);
                    int left = ch;
                    int next = 0;
                    while (true) {
                        ch = this.reader.read();
                        next = this.reader.lookAhead();
                        if (this.isQuoteChar(ch)) {
                            token.markQuote(ch);
                        }
                        if (ch == 92) {
                            token.content.append((char)ch);
                            ch = this.reader.skipReads(1);
                            token.content.append((char)ch);
                            continue;
                        }
                        if (ch == left && next == left) {
                            token.content.append((char)ch);
                            continue;
                        }
                        if (token.isQuoteClose() && this.isEndOfToken(ch)) {
                            token.type = Token.Type.TOKEN;
                            token.count = 0;
                            token.firstQuote = -1;
                            break block20;
                        }
                        if (token.isQuoteClose() && (this.isSingleCommentStart(ch) || this.isMultiCommentStart(ch))) {
                            token.type = Token.Type.COMMENT;
                            break block20;
                        }
                        token.content.append((char)ch);
                    }
                }
                if (this.isMultiCommentStart(ch)) {
                    while (!this.isMultiCommentEnd(ch = this.reader.read())) {
                    }
                    ch = this.reader.skipReads(2);
                } else if (this.isSingleCommentStart(ch)) {
                    while (!this.isEndOfLine(ch = this.reader.read())) {
                    }
                } else {
                    token.content.append((char)ch);
                    ch = this.reader.read();
                }
            }
            if (this.isEndOfLine(ch)) {
                this.ignoreIrrelevantStmt(token);
                continue;
            }
            if (this.isEndOfFile(ch)) {
                token.type = Token.Type.EOF;
                break;
            }
            if (!this.isEndOfStmt(ch)) continue;
            if (!this.ignoreIrrelevantStmt(token)) {
                token.type = Token.Type.EOS;
                break;
            }
            ch = this.reader.skipReads(1);
        }
        return token;
    }

    boolean ignoreIrrelevantStmt(Token token) {
        StringBuilder content = token.content;
        if (StringUtils.isBlank(content)) {
            token.content.setLength(0);
            return true;
        }
        if (content.length() > 0 && content.length() < 200 && FILTER_PATTERN.matcher(content.toString()).matches()) {
            token.content.setLength(0);
            return true;
        }
        return false;
    }

    long getCurrentLineNumber() {
        return this.reader.getCurrentLineNumber();
    }

    long getCharacterPosition() {
        return this.reader.getPosition();
    }

    boolean isEndOfLine(int ch) throws IOException {
        if (ch == 13 && this.reader.lookAhead() == 10) {
            ch = this.reader.read();
            if (this.firstEol == null) {
                this.firstEol = "\r\n";
            }
        }
        if (this.firstEol == null) {
            if (ch == 10) {
                this.firstEol = LF_STRING;
            } else if (ch == 13) {
                this.firstEol = CR_STRING;
            }
        }
        return ch == 10 || ch == 13;
    }

    boolean isEndOfToken(int ch) throws IOException {
        return ch == 44 || this.isEndOfStmt(ch) || ch == 41;
    }

    boolean isEndOfStmt(int ch) throws IOException {
        String delim = this.getDelimiter();
        boolean end = ch == delim.charAt(0);
        for (int i = 1; i < delim.length(); ++i) {
            end &= this.reader.lookAhead(i) == delim.charAt(i);
        }
        return end;
    }

    boolean isClosed() {
        return this.reader.isClosed();
    }

    boolean isWhitespace(int ch) {
        return CharUtils.isWhitespace(ch);
    }

    boolean isStartOfLine(int ch) {
        return ch == 10 || ch == 13;
    }

    boolean isEndOfFile(int ch) {
        return ch == -1;
    }

    boolean isQuoteChar(int ch) {
        return ch == 96 || ch == 34 || ch == 39;
    }

    boolean isSingleCommentStart(int ch) throws IOException {
        return ch == 45 && this.reader.lookAhead() == 45 || ch == 35;
    }

    boolean isMultiCommentStart(int ch) throws IOException {
        return ch == 47 && this.reader.lookAhead() == 42 && (this.reader.lookAhead(2) != 33 && this.reader.lookAhead(2) != 43 || this.reader.lookAhead(2) == 33 && Character.isDigit(this.reader.lookAhead(3)));
    }

    boolean isMultiCommentEnd(int ch) throws IOException {
        return ch == 42 && this.reader.lookAhead() == 47;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public String getFirstEol() {
        return this.firstEol;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

